{************************************************}
{ STYX DEMO FOR TVDEMO, using TVGRAPH            }
{************************************************}

unit Styx;

{$F+,O-,X+,S-,D+,L+}

{ Graphics Styx demo }

interface

uses TvGraph, DemoCmds, Objects, App, Views, Drivers;

const
 cmStyx=1100;
type
  PStyx = ^TStyx;
  TStyx = object(gObject)
    CurrentStick:byte;
    StyxLocations:Array[0..15] of gLine;
    vXA,vYA,vXB,vYB:integer;
    constructor Init;
    procedure GraphProd; virtual;
    procedure GraphDraw(R:TRect); virtual;
  end;

  PStyxDemo = ^TStyxDemo;
  TStyxDemo = object(gWindow)
    constructor Init;
  end;

implementation

constructor TStyx.Init;
var
 C:word;
begin
 CurrentStick:=0;
 for C:=0 to 15 do
    Styxlocations[C].Init(GraphXMax div 3,GraphYMax div 3,
                          GraphXMax div 2,GraphYMax div 2,15);
 vXA:=random(8)+1;if vXA>4 then vXA:=4-vXA;
 vXA:=vXA*16;
 vYA:=random(8)+1;if vYA>4 then vYA:=4-vYA;
 vYA:=vYA*16;
 vXB:=random(8)+1;if vXB>4 then vXB:=4-vXB;
 vXB:=vXB*16;
 vYB:=random(8)+1;if vYB>4 then vYB:=4-vYB;
 vYB:=vYB*16;

 for C:=1 to 16 do GraphProd;
end;

procedure TStyx.GraphDraw(R:TRect);
const
 StyxColor:array[0..15] of byte =(15,11,11,9,9,9,9,1,1,1,1,1,1,1,1,0);
var
 Count:byte;
 Actual:byte;
begin
 for count:=0 to 15 do
 begin
    Actual:=(16-Count+CurrentStick) mod 16;
    begin
     Styxlocations[Count].ChangeColor(StyxColor[Actual]);
     Styxlocations[Count].GraphDraw(R);
    end;
  end;
end;

procedure TStyx.GraphProd;
var
 Count:byte;
 LS:byte;
begin
 LS:=CurrentStick;
 CurrentStick:=(CurrentStick+1) mod 16;
 with Styxlocations[CurrentStick] do
   begin
      ChangeEndsCopy(StyxLocations[LS]);
      DeltaEnds(vXa,vYa,vXb,vYb);
      if (XA=0) or (XA=GraphXMax) then vXa:=-vXa;
      if (YA=0) or (YA=GraphYMax) then vYa:=-vYa;
      if (XB=0) or (XB=GraphXMax) then vXb:=-vXb;
      if (YB=0) or (YB=GraphYMax) then vYb:=-vYb;
   end;
end;

constructor TStyxDemo.Init;
var
  R  : TRect;
  GV : pgView;
  PB : pStyx;
begin
  R.Assign(0, 0, 34, 12);
  TWindow.Init(R, 'S T Y X', wnNoNumber);
  GetExtent(R);
  R.Grow(-1,-1);
  GV:=New(pgView,Init(R));
  PB:=New(pStyx,Init);
  if (GV<>nil) and (PB<>nil) then
    begin
     GV^.Insert(PB);
     Insert(GV);
    end else if GV<>nil then Dispose(GV,Done)
                        else Dispose(PB,Done);
end;

end.
