/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include <stdio.h>
#include <process.h>

#define Uses_MsgBox
#define Uses_TApplication

#include "tvtools.h"
#include "tools.h"


const char *checkMsg = " \n\03Checking Floppy format...";

const char *formatMsg = "\03Formatting floppy...";


static ushort chkdsk( int floppy )
{
 int status;
 const char *msg;

 for (;;)
     {
      StatusBox( checkMsg );
      status = test_drive( floppy );
      RemoveStatusBox();

      if ( (status & D_INVALID) || (status & D_NOFORMAT) ) return -1; // not formatted

      msg = NULL;
      if ( ! (status & D_WRITEABLE) ) msg = "write-protected"; // write-protected
      if ( status & D_NOTINSERTED ) msg = "not inserted"; // not inserted
      if ( ! msg ) return cmOK;  // already formatted

      status = messageBox( mfOKCancel,
                           "\03Floppy %c: is %s.\n \n"
                           "\03Correct and retry?",
                           floppy + 'A', msg
                         );
      if ( status != cmOK ) return cmCancel;
     }
}


/***
 *
 *  Function   :    formatFloppy
 *
 *  Topics     :    Format a floppy if needed.
 *
 *  Decisions  :    - Calls the DOS command FORMAT x: [/T:nn /N:nn] /V:""
 *                  - A check is performed after the format.
 *                  - If DOS version >= 4.0 use the /AUTOTEST switch
 *                    (undocumented) to skip prompt.
 *                  - If DOS version >= 5.0 use the /U switch
 *                    to speed up format.
 *
 *  Parameters :    in    int  floppy ( 0 = A:, 1 = B: )
 *
 *  Return     :    cmOK or cmCancel
 *
 ***/

ushort formatFloppy( int floppy )
{
 if ( floppy < 0 || floppy > 1 ) return cmCancel;

 int status = chkdsk( floppy );
 if ( status == cmOK || status == cmCancel ) return status;

  do { // Format floppy

      char *density = "";

      if ( getdensity(floppy) == 1440 )
         {
          status = messageBox( "\03Is the Floppy a High Density one ?\n \n"
                               "\03(1.44 Mb)",
                               mfYesNoCancel
                             );
          if ( status == cmCancel ) return cmCancel;
          if ( status == cmNo ) density = "/N:9 /T:80";
          status = 0;
         }

      char buffer[512];
      sprintf( buffer, "format %c: %s /v:\"\"", floppy + 'A', density );
      if ( _osmajor >= 4 ) strcat( buffer, " /autotest" );  // Undocumented: no confirmation
      if ( _osmajor >= 5 ) strcat( buffer, " /u" );         // To speed up format

      StatusBox( formatMsg );
      appSystem( buffer );

      status = chkdsk( floppy );
      if ( status == cmOK || status == cmCancel ) return status;

      if ( messageBox( "\03Floppy is not formatted.\n \n"
                       "\03Retry ?",
                       mfOKCancel
                     ) != cmOK
         ) return cmCancel;

     } while ( 1 );
}
