/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#define Uses_TStreamable
#define Uses_MsgBox
#define Uses_TInputInt
#include "tvtools.h"
__link( RInputLine )


#include <string.h>
#include <stdio.h>
#include <values.h>
#include <stdlib.h>
#include <strstream.h>


// TInputInt

const char * const TInputInt::name = "TInputInt";

void TInputInt::write( opstream& os )
{
  TInputLine::write( os );
  os << min;
  os << max;
}

void *TInputInt::read( ipstream& is )
{
  TInputLine::read( is );
  is >> min;
  is >> max;
  return this;
}

TStreamable *TInputInt::build()
{
  return new TInputInt( streamableInit );
}


TStreamableClass RInputInt( TInputInt::name,
                             TInputInt::build,
                             __DELTA(TInputInt)
                           );

TInputInt::TInputInt( const TRect& bounds,
                      int aMaxLen,
                      int aMin,
		      int aMax
                    )
          :TInputRegExp( bounds, aMaxLen, "-0-9" )
{
  min = aMin;
  max = aMax;
}


TInputInt::TInputInt( int x,
                      int y,
                      int aMaxLen,
                      int aMin,
		      int aMax
                    )
          :TInputRegExp( x, y, aMaxLen, "-0-9" )
{
  min = aMin;
  max = aMax;
}


ushort TInputInt::dataSize()
{
  return sizeof( int );
}

void TInputInt::getData( void *rec )
{
  *(int *)rec = atoi(data);
}

void TInputInt::setData( void *rec )
{
  itoa(*(int *)rec, data, 10);
  selectAll(True);
}

Boolean TInputInt::valid( ushort command )
{
  switch( command )
        {
          case cmReleasedFocus: return True;

          case cmQuit :
          case cmClose:
          case cmOK   : int value = atoi( data );
                        if ( (! *data) || (value < min) || (value > max) || (! value && *data) )
                           {
                             select();
                             messageBox( mfError | mfOKButton,
                                         "\03Number must be between %d and %d.",
                                         min, max
                                       );
                             selectAll( True );
                             return False;
                           }
                        break;
        }

  return TInputRegExp::valid( command );
}
