/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

class TStreamable;
#include <values.h>
#include "strings.h"


#if defined(Uses_TInputKey) && ! defined(__TInputKey)
#define __TInputKey
// Same as TInputLine, except invalid if empty

class TInputKey : public TInputLine
{

public:

    TInputKey( const TRect&, int len );
    TInputKey( int x, int y, int len );
    virtual Boolean valid( ushort );

protected:

    TInputKey( StreamableInit ) : TInputLine( streamableInit ) {};

private:

    virtual const char *streamableName() const
        { return name; }

public:

    static const char * const name;
    static TStreamable *build();

};


inline ipstream& operator >> ( ipstream& is, TInputKey& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TInputKey*& cl )
    { return is >> (void *&)cl; }
inline opstream& operator << ( opstream& os, TInputKey& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TInputKey* cl )
    { return os << (TStreamable *)cl; }

#endif // Uses_TInputKey



#if defined(Uses_TInputPasswd) && ! defined(__TInputPasswd)
#define __TInputPasswd
// Same as TInputLine, but display only '*'

class TInputPasswd : public TInputLine
{

public:

    TInputPasswd( const TRect&, int len );
    TInputPasswd( int x, int y, int len );
    virtual void draw( void );

protected:

    TInputPasswd( StreamableInit ) : TInputLine( streamableInit ) {};

private:

    virtual const char *streamableName() const
        { return name; }

public:

    static const char * const name;
    static TStreamable *build();

};


inline ipstream& operator >> ( ipstream& is, TInputPasswd& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TInputPasswd*& cl )
    { return is >> (void *&)cl; }
inline opstream& operator << ( opstream& os, TInputPasswd& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TInputPasswd* cl )
    { return os << (TStreamable *)cl; }


ushort inputPasswdBoxRect( const TRect &bounds,
                           const char *Title,
                           const char *aLabel,
                           char *s,
                           uchar limit );


ushort inputPasswdBox( const char *Title, const char *aLabel, char *s, uchar limit );


#endif // Uses_TInputPasswd



#if defined(Uses_TInputRegExp) && ! defined(__TInputRegExp)
#define __TInputRegExp
// Accepts only regular expression-matching input

class TInputRegExp: public TInputLine
{

public:

#pragma warn -bei
    TInputRegExp( const TRect&, int , const char * = 0, const char * = 0, casetype = 0 );
    TInputRegExp( int x, int y, int , const char * = 0, const char * = 0, casetype = 0 );
    virtual ~TInputRegExp();
    virtual void setState( ushort, Boolean );
    virtual void handleEvent( TEvent& );
    virtual Boolean valid( ushort );

protected:

    TInputRegExp( StreamableInit ) : TInputLine( streamableInit ) {};

private:

    virtual void init( const char *aSet, const char *aRegexp, casetype aNewcase );
    char *set, *regexp;
    casetype newcase;

    virtual const char *streamableName() const
        { return name; }

public:

    static const char * const name;
    static TStreamable *build();
    static char *invMsg;
};


inline ipstream& operator >> ( ipstream& is, TInputRegExp& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TInputRegExp*& cl )
    { return is >> (void *&)cl; }
inline opstream& operator << ( opstream& os, TInputRegExp& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TInputRegExp* cl )
    { return os << (TStreamable *)cl; }

#endif //  Uses_TInputRegExp


#if defined(Uses_TInputInt) && ! defined(__TInputInt)
#define __TInputInt
// Accepts only valid numeric input (int) between Min and Max

class TInputInt : public TInputRegExp
{

public:

    TInputInt( const TRect&, int len = 7, int min = -MAXINT, int max = MAXINT );
    TInputInt( int x, int y, int len = 7, int min = -MAXINT, int max = MAXINT );
    virtual ushort dataSize();
    virtual void getData( void *);
    virtual void setData( void *);
    virtual Boolean valid( ushort );
    int min;
    int max;

protected:

    TInputInt( StreamableInit ) : TInputRegExp( streamableInit ) {};
    virtual void write( opstream& );
    virtual void *read( ipstream& );

private:

    virtual const char *streamableName() const
        { return name; }

public:

    static const char * const name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TInputInt& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TInputInt*& cl )
    { return is >> (void *&)cl; }
inline opstream& operator << ( opstream& os, TInputInt& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TInputInt* cl )
    { return os << (TStreamable *)cl; }

#endif // Uses_TInputInt





#if defined(Uses_TInputLong) && ! defined(__TInputLong)
#define __TInputLong
// Accepts only valid numeric input (long) between Min and Max

class TInputLong : public TInputRegExp
{

public:

    TInputLong( const TRect&, int len = 12, long min = -MAXLONG, long max = MAXLONG );
    TInputLong( int x, int y, int len = 12, long min = -MAXLONG, long max = MAXLONG );
    virtual ushort dataSize();
    virtual void getData( void *);
    virtual void setData( void *);
    virtual Boolean valid( ushort );
    long min;
    long max;

protected:

    TInputLong( StreamableInit ) : TInputRegExp( streamableInit ) {};
    virtual void write( opstream& );
    virtual void *read( ipstream& );

private:

    virtual const char *streamableName() const
        { return name; }

public:

    static const char * const name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TInputLong& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TInputLong*& cl )
    { return is >> (void *&)cl; }
inline opstream& operator << ( opstream& os, TInputLong& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TInputLong* cl )
    { return os << (TStreamable *)cl; }

#endif // Uses_TInputLong





#if defined(Uses_TInputDouble) && ! defined(__TInputDouble)
#define __TInputDouble
// Accepts only valid numeric input between Min and Max

class TInputDouble : public TInputRegExp
{

public:

    TInputDouble( const TRect&, int len = 15, double min = -MAXDOUBLE, double max = MAXDOUBLE );
    TInputDouble( int x, int y, int len = 15, double min = -MAXDOUBLE, double max = MAXDOUBLE );
    virtual ushort dataSize();
    virtual void getData( void *);
    virtual void setData( void *);
    virtual Boolean valid( ushort );
    double min;
    double max;

protected:

    TInputDouble( StreamableInit ) : TInputRegExp( streamableInit ) {};
    virtual void write( opstream& );
    virtual void *read( ipstream& );

private:

    virtual const char *streamableName() const
        { return name; }

public:

    static const char * const name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TInputDouble& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TInputDouble*& cl )
    { return is >> (void *&)cl; }
inline opstream& operator << ( opstream& os, TInputDouble& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TInputDouble* cl )
    { return os << (TStreamable *)cl; }

#endif //  Uses_TInputDouble



#if defined(Uses_TInputHexa) && ! defined(__TInputHexa)
#define __TInputHexa
// Accepts only valid hexadecimal string input

class TInputHexa : public TInputRegExp
{

public:

    TInputHexa( const TRect&, int len );
    TInputHexa( int x, int y , int len );

protected:

    TInputHexa( StreamableInit ) : TInputRegExp( streamableInit ) {};

private:

    virtual const char *streamableName() const
        { return name; }

public:

    static const char * const name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TInputHexa& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TInputHexa*& cl )
    { return is >> (void *&)cl; }
inline opstream& operator << ( opstream& os, TInputHexa& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TInputHexa* cl )
    { return os << (TStreamable *)cl; }

#endif // Uses_TInputHexa





#if defined(Uses_TInputDate) && ! defined(__TInputDate)
#define __TInputDate
// Accepts only valid date input

class TInputDate: public TInputRegExp
{

public:

    TInputDate( const TRect& );
    TInputDate( int x, int y );
    virtual Boolean valid( ushort );

public:

    static const char * const name;

};
#endif //  Uses_TInputDate


#if defined(Uses_TInputCalcul) && ! defined(__TInputCalcul)
#define __TInputCalcul

// Accepts a calculation string

class TInputCalcul : public TInputRegExp
{

public:

    TInputCalcul( const TRect&, int len );
    TInputCalcul( int x, int y, int len );
    virtual Boolean valid( ushort );

protected:

    TInputCalcul( StreamableInit ) : TInputRegExp( streamableInit ) {};

private:

    virtual const char *streamableName() const
        { return name; }

public:

    static const char * const name;
    static TStreamable *build();

};


inline ipstream& operator >> ( ipstream& is, TInputCalcul& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TInputCalcul*& cl )
    { return is >> (void *&)cl; }
inline opstream& operator << ( opstream& os, TInputCalcul& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TInputCalcul* cl )
    { return os << (TStreamable *)cl; }

#endif // Uses_TInputCalcul


#if defined(Uses_TStaticInputLine) && ! defined(__TStaticInputLine)
#define __TStaticInputLine

// Accepts a static string

class TStaticInputLine : public TInputRegExp
{
protected:
           TGenCollection *list;

public:
           TStaticInputLine( const TRect&, int, TGenCollection *aList );
           TStaticInputLine( int, int, int, TGenCollection *aList );

//           virtual TPalette& getPalette() const;
           virtual void setData( void *rec );
           virtual void handleEvent( TEvent& event );
           virtual Boolean valid( ushort command );
           virtual void newList( TGenCollection *aList );

public:
           static const char * const near name;
           char  testChar[255];
};

#endif
