/* crlf.c: convert text file between <CR><LF> format and <LF> format. */
/* Intended use: on MS-DOS systems to convert from/to Unix format */
/* Written by Steve Creps, 5-12-88, all rights reserved */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <io.h>
#include <ctype.h>

static unsigned optr = 0;

main(argc, argv)
int argc;
char *argv[];
{
	FILE *fp;
	char c;
	unsigned dash = 0;

	while (argc > 1 && argv[1][0] == '-' && !dash) {
		argv++;
		argc--;
		switch(argv[0][1]){
		case 'r':
			optr = 1;
			break;
		case '\0':
			dash = 1;
			break;
		default:
			fprintf(stderr, "crlf: unknown option: %s\n", *argv);
			return(1);
		}
	}

	if (argc != 1 && argc != 2) {
		fprintf(stderr, "Usage: crlf [-r -] file\n");
		return(2);
	}
	if (optr) setmode(fileno(stdout), O_BINARY);
	if (argc == 1) {
		if (!optr) setmode(fileno(stdin), O_BINARY);
		catfile(stdin);
	} else if ((fp = fopen(*++argv, "r")) == NULL) {
			fprintf(stderr, "crlf: cannot open %s\n", *argv);
			return(3);
	} else {
			if (!optr) setmode(fileno(fp), O_BINARY);
			catfile(fp);
			fclose(fp);
		}
}


catfile(fp)
FILE *fp;
{
	char c;

	while ((c = getc(fp)) != EOF) {
		while (c != '\n' && c != EOF) {
			putc(c, stdout);
			c = getc(fp);
		}
		putc(c, stdout);
	    }
	    return;
}
