Program EBCDIC;   {Converts EBCDIC to ASCII}

{

     This program was developed out of a need to convert IBM mainframe
     data stored in EBCDIC format into data that could easily be imported
     to DBASE III and/or DBASE III+.  I used the Black Box catalog for the
     code conversions from EBCDIC to ASCII.  Be sure that your data does
     not contain any COMP3 or COMP fields (packed numeric).  This program
     will not handle those.

}

type

  filename     = String[64];

var

  infile       : file of byte;
  outfile      : text;
  j            : integer;
  i            : integer;
  tempbyte     : byte;
  e2a          : array[$00..$ff] of byte; {Array that holds EBCDIC to ASCII.}
  infilename   : filename;
  outfilename  : filename;

Procedure Wind(Left,Top,Right,Bottom : Integer);

  Procedure Box(Left,Top,Right,Bottom : Integer);

    var
      i : Integer;

    begin
      GotoXY(Left-1,Top-1);
      Write('');
      GotoXY(Right+1,Top-1);
      Write('');
      GotoXY(Left-1,Bottom+1);
      Write('');
      GotoXY(Right+1,Bottom+1);
      Write('');
      for i := Top to Bottom do begin
        GotoXY(Left-1,i);
        Write('');
        GotoXY(Right+1,i);
        Write('');
        end;
      for i := Left to Right do begin
        GotoXY(i,Top-1);
        Write('');
        GotoXY(i,Bottom+1);
        Write('');
        end;
    end;

  begin
    Box(Left,Top,Right,Bottom);
    Window(Left,Top,Right,Bottom);
    Clrscr;
  end;

Procedure Initialize;   {Load up the Array for EBCDIC to ASCII conversion.}

  var
    i            : integer;

  begin
       for i := 0 to 255 do e2a[i] := 32; {Initialize the whole array.}
       e2a[$C1]   := 65;                  {Load individual character values.}
       e2a[$C2]   := 66;                  {Index value is EBCDIC value.}
       e2a[$C3]   := 67;
       e2a[$C4]   := 68;
       e2a[$C5]   := 69;
       e2a[$C6]   := 70;
       e2a[$C7]   := 71;
       e2a[$C8]   := 72;
       e2a[$C9]   := 73;
       e2a[$D1]   := 74;
       e2a[$D2]   := 75;
       e2a[$D3]   := 76;
       e2a[$D4]   := 77;
       e2a[$D5]   := 78;
       e2a[$D6]   := 79;
       e2a[$D7]   := 80;
       e2a[$D8]   := 81;
       e2a[$D9]   := 82;
       e2a[$E2]   := 83;
       e2a[$E3]   := 84;
       e2a[$E4]   := 85;
       e2a[$E5]   := 86;
       e2a[$E6]   := 87;
       e2a[$E7]   := 88;
       e2a[$E8]   := 89;
       e2a[$E9]   := 90;
       e2a[$81]   := 97;
       e2a[$82]   := 98;
       e2a[$83]   := 99;
       e2a[$84]   := 100;
       e2a[$85]   := 101;
       e2a[$86]   := 102;
       e2a[$87]   := 103;
       e2a[$88]   := 104;
       e2a[$89]   := 105;
       e2a[$91]   := 106;
       e2a[$92]   := 107;
       e2a[$93]   := 108;
       e2a[$94]   := 109;
       e2a[$95]   := 110;
       e2a[$96]   := 111;
       e2a[$97]   := 112;
       e2a[$98]   := 113;
       e2a[$99]   := 114;
       e2a[$A2]   := 115;
       e2a[$A3]   := 116;
       e2a[$A4]   := 117;
       e2a[$A5]   := 118;
       e2a[$A6]   := 119;
       e2a[$A7]   := 120;
       e2a[$A8]   := 121;
       e2a[$A9]   := 122;
       e2a[$F0]   := 48;
       e2a[$F1]   := 49;
       e2a[$F2]   := 50;
       e2a[$F3]   := 51;
       e2a[$F4]   := 52;
       e2a[$F5]   := 53;
       e2a[$F6]   := 54;
       e2a[$F7]   := 55;
       e2a[$F8]   := 56;
       e2a[$F9]   := 57;
       e2a[$40]   := 32;
       e2a[$5A]   := 33;
       e2a[$7F]   := 34;
       e2a[$7B]   := 35;
       e2a[$5B]   := 36;
       e2a[$6C]   := 37;
       e2a[$50]   := 38;
       e2a[$7D]   := 39;
       e2a[$4D]   := 40;
       e2a[$5D]   := 41;
       e2a[$5C]   := 42;
       e2a[$4E]   := 43;
       e2a[$6B]   := 44;
       e2a[$60]   := 45;
       e2a[$4B]   := 46;
       e2a[$61]   := 47;
       e2a[$7A]   := 58;
       e2a[$5E]   := 59;
       e2a[$4C]   := 60;
       e2a[$7E]   := 61;
       e2a[$6E]   := 62;
       e2a[$6F]   := 63;
       e2a[$7C]   := 64;
       e2a[$E0]   := 92;
       e2a[$6D]   := 95;
       e2a[$C0]   := 123;
       e2a[$6A]   := 124;
       e2a[$D0]   := 125;
       e2a[$A1]   := 126;
       e2a[$4A]   := 155;
       e2a[$5F]   := 191;
       e2a[$2E]   := 6;
       e2a[$2F]   := 7;
       e2a[$16]   := 8;
       e2a[$18]   := 24;
       e2a[$0D]   := 13;
       e2a[$11]   := 17;
       e2a[$12]   := 18;
       e2a[$13]   := 19;
       e2a[$3C]   := 20;
       e2a[$07]   := 127;
       e2a[$10]   := 16;
       e2a[$19]   := 25;
       e2a[$2D]   := 5;
       e2a[$37]   := 4;
       e2a[$27]   := 27;
       e2a[$26]   := 23;
       e2a[$03]   := 3;
       e2a[$0C]   := 12;
       e2a[$22]   := 28;
       e2a[$05]   := 9;
       e2a[$25]   := 10;
       e2a[$3D]   := 21;
       e2a[$00]   := 0;
       e2a[$35]   := 30;
       e2a[$0F]   := 15;
       e2a[$0E]   := 14;
       e2a[$01]   := 1;
       e2a[$02]   := 2;
       e2a[$32]   := 22;
       e2a[$0B]   := 11;
  end;

Procedure Ebcdic(var tempbyte:byte);  {Convert a byte to ASCII.}

  begin
    tempbyte := e2a[tempbyte];
  end;



{Here is the main part of the program.}


begin

     Initialize;
     ClrScr;
     Wind(6,2,74,11);
     Writeln('Author - Lou Seigal     Date: 11/29/86');
     Writeln;
     Writeln('  This program will convert EBCDIC data to an ASCII text file');
     Writeln('conforming to SDF format for importation into DBASE III or');
     Writeln('DBASE III+.');
     Writeln('  You must know the structure of your source data file so you can');
     Writeln('build the DBASE file properly.');
     Window(1,1,80,25);
     Wind(2,14,79,16);
     Write('     Enter source file name : ');
     Readln(infilename);
     Write('Enter destination file name : ');
     Readln(outfilename);
     Window(1,1,80,25);
     Wind(2,19,79,23);
     Writeln('                            Converted Data');
     Window(2,20,79,23);
     Assign(infile,infilename);
     Reset(infile);
     Assign(outfile,outfilename);
     Rewrite(outfile);
     while not eof(infile) do begin
       read(infile,tempbyte);
       ebcdic(tempbyte);
       write(chr(tempbyte));
       write(outfile,chr(tempbyte));
     end;
     Close(infile);
     Close(outfile);
     Window(1,1,80,25);
     ClrScr;
     Writeln('I am done converting ',infilename,' to ',outfilename,'.');
end.
