/* Strings.C
 *
 * Displays a list of all strings in a file read from a file that
 * are entirely ASCII -- that is, between 32 and 126. Must be at least four
 * characters long, or however many as specified by an argument to the
 * program.
 *
 * Syntax: strings <filename> [<min_chars>] [/X]
 */

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <string.h>

#define SYNMSG		"strings: syntax <filename> [<min_chars>] [/X]"
#define NOPMSG		"strings: unable to open file"
#define NOSTOR		"strings: unable to allocate storage"

char copyright[] = "STRINGS v1.1 dated " __DATE__ ", Copyright 1990 by "
			    "Daniel Sachs.";

void main(int argc, char *argv[])
{
	int min_chars;
	int cur_char;
	unsigned long pos;
	unsigned long beg;
	FILE *fp;
	char *tmp;
	char c;
	int printed;
	int hexflag;

	if( (argc < 2) || (argc > 4) )
	{
		printf(SYNMSG);
		exit(2);
	}

	if( argc == 2 && !stricmp(argv[1],"/C") )
	{
		printf(copyright);
		exit(0);
	}

	if( argc == 3 && stricmp(argv[2],"/X") )
		min_chars = atoi(argv[2]);
	else
		min_chars = 4;

	if( argc == 4 )
		min_chars = atoi(argv[2]);

	if( min_chars == 0 )
	{
		printf(SYNMSG);
		exit(2);
	}

	if( !stricmp(argv[argc-1],"/X") )
		hexflag = 1;
	else
		hexflag = 0;

	if( argc == 4 && !hexflag)
	{
		printf(SYNMSG);
		exit(2);
	}

	fp = fopen(argv[1],"rb");

	if( fp == NULL )
	{
		printf(NOPMSG);
		exit(2);
	}

	tmp = malloc(min_chars+1);

	if( tmp == NULL )
	{
		printf(NOSTOR);
		exit(2);
	}

	printf("Offset\tString\n");

	cur_char = 0;
	beg = 0;
	printed = 0;

	for(pos = 0;;pos++)
	{
		fread(&c,1,1,fp);

		if( feof(fp) )
			break;

		else
		{
			if( (c > 31) && (c < 127) )
			{
				cur_char++;
				if (cur_char > min_chars)
					putchar(c);
				if (cur_char == min_chars)
				{
					printf(hexflag ? "%lX\t%s%c" :
						"%li\t%s%c", beg, tmp, c);
					printed = 1;
				}
				if (cur_char < min_chars)
				{
					*(tmp + (cur_char-1)) = c;
					*(tmp + cur_char    ) = 0;
				}
				if (cur_char == 1)
					beg = pos;
			}
			else
			{
				if( cur_char != 0 )
				{
					cur_char = 0;
					if (printed)
					{
						printf("\n");
						printed = 0;
					}
				}
			}
		}
	}
}
