#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#define IMPORT  extern
#define DATA    static
#define SHARE   
#define METHOD  extern 

IMPORT char    *stpncpy();
IMPORT char    *rstrncpy();

/* output buffer data */
DATA char    *t;                /* write to here         */
DATA char    *obuffer;
DATA int      obuffersize;
DATA char    *obufferlim;

/* output buffer interace */
METHOD void     out_line ();
METHOD void     out_word ();
METHOD void     out_space();
METHOD void     out_flush();
METHOD void     out_reset();
METHOD void     out_new ();

/* shared output buffer data */
SHARE  int      oflag;        /* output buffer nonempty */

/* shared global data */
IMPORT int      sl;                /* room remaining on output line */
IMPORT int      sp;                /* spaces output on line  */
IMPORT char     mode;   /* p,l,r,c, as above      */
IMPORT int      rm;                /* right margin           */
IMPORT char     boxchar;


void          out_reset ()
/* set the ouput buffer pointer back to the origin */
{
    t = obuffer;
}


void            out_put (s)
/* send a string to the output buffer t.
 */
    char           *s;
{
    t = stpncpy (t, s, obufferlim - t /*- 256*/);

/*    if (t>=obufferlim-256 && obufferlim[-256])
    usage (6);         /* need a bigger buffer */
    if (t>obuffer && t[-1]=='\n')
       *--t=0;         /* mend extra newlines at end of words */
}


void            out_word (l, s)
/* send a word to the output buffer at t.
 * set oflag=1 to indicate buffer has data.
 */
    int             l;
    char           *s;
{
    sl -= l;
    out_put (s);
    if (!oflag)
        oflag = 1;
}

void            out_space ()
/* send a space to the output buffer at t. */
{
    sp++;
    sl--;
    out_put (" ");
}

void            out_flush (flag, boxflag)
    int         flag, boxflag;
/* send the output buffer t to the outside world.
 * set oflag=0 to show buffer clear.
 * if flag=0 on entry, don't pad.
 * if boxflag!=0, make a box surround.
 */
{
    out_reset();
    if (flag)
    switch (mode) {
      case 'p':
      pad (t);
          break;
      case 'r':
          right (t);
          break;
      case 'c':
          centre (t);
          break;
      case 'l':
          break;
    }
    if (boxflag && boxchar) {
        rstrncpy(t+2,t,rm-sl);
        *t=boxchar;
        t[1]=' ';
        if (sl>0)
          memset(t+rm-sl+2,' ',sl);
        t[rm+2]=' ';
        t[rm+3]=boxchar;
        t[rm+4]=0;
    }
    sl = rm;                       /* reset slack space and space count */
    sp = 0;

    puts (obuffer);                /* write the obuffer to stdout */

    *t = 0;                        /* (a precaution) */
    oflag = 0;                     /* obuffer emptied */
}

void            out_line ()
/* send the input buffer for output unchanged */
{
    in_out ();
    out_flush (0,0);               /* don't just or box */
}

void            out_boxline ()
/* send a line of boxchars for output. */
{
    memset(t,boxchar,rm+4);
    t[rm + 4] = 0;
    out_flush (0,0);
}

void        out_new (n)
/* make a new output buffer of size n.
  set obuffersize, obuffer and obufferlim.
 */
    int     n;
{
    obuffersize = n;
    obuffer = (char *) calloc (obuffersize, sizeof (char));
    if (obuffer == 0)
        usage (5);
    obufferlim = obuffer + obuffersize;
}

