/*
 *      getpwnam.c: Get password file entry by name
 *
 *      Stephen C. Trier
 *      March 26, 1990
 *
 *      This program is in the public domain
 *
 */

#include <stdio.h>
#include <string.h>
#include <pwd.h>

extern FILE *_pw_file;

struct passwd *getpwnam(char *name)
{
    struct passwd *temp;

    if (setpwent())
	return NULL;
    while (temp = getpwent())
	if (strcmp(temp->pw_name, name) == 0)  {
	    setpwent();
	    return temp;
	    }
    setpwent();
    return NULL;
}

