/*
 *      getpwuid.c: Get password file entry by user id
 *
 *      Stephen C. Trier
 *      March 26, 1990
 *
 *      This program is in the public domain
 *
 */

#include <stdio.h>
#include <pwd.h>

extern FILE *_pw_file;

struct passwd *getpwuid(int id)
{
    struct passwd *temp;

    if (setpwent())
	return NULL;
    while (temp = getpwent())
	if (temp->pw_uid == id)  {
	    setpwent();
	    return temp;
	    }
    setpwent();
    return NULL;
}


