/* cputzp.c  -  Decoding image in ZPacked format to VRAM, CHAINED mode.
 *
 * Description:
 *   Format ZPacked is quiet the same as Z4Planes but without breaking
 *   into planes.
 *   Uses the coding method, described in mputz4p.c
 * See Also:
 *      mputz4p.c, uputz4p.c
 * Functions:
 *      CputZPacked().
 * Portability: BORLANDC
 *                                      (c) erdy 1992
 * $Header: $
 */
#pragma inline
#include "far.h"
#include "vgaprefx.h"
#include "vgadrv.h"
#include "screen.h"


void CputZPacked(char far *image, unsigned x, unsigned y, int rows)
        /* in case of ZC_PREPARED x is unused, y contains VRAM offset.
         */
{
        _ES = Scdraw_seg;

	asm push ds;
	asm lds si, image;
	asm cld;
#       ifdef ZC_PREPARED
                asm mov di, y;
#       else  ZC_PREPARED
                _DI = VIDEO_CADDRESS(x, y);
#       endif ZC_PREPARED

         /* CX contains row counter.
         */
        asm mov cx, rows;
        asm push bp;
        asm mov dx, BPERROW_CHAINED;
        asm xor ah, ah;
RowLoop:
                /*
                 * Scanlines loop. CX contains nrows.
                 *
                 * Sequence of the alhorithm follows the most frequent image
                 * sequence: <skip>, <literal>, <skip/eol>.
                 * Thus, at least 3 jumps per line are saved.
                 *
                 * Scratch registers:
                 *      bx - saving the ram index (di)
                 *      bp - saving the loop counter (cx)
                 */
                asm mov bx, di;                 /* Save ram index */
                asm mov bp, cx;                 /* Save loop counter */
                asm xor ch, ch;                 /* Zero high byte, ch always zero */
                /* Loop until EOL */
LineLoop:
                        asm lodsb;              /* Get next image byte */
                        asm or al, al;          /* Query flags */
                        asm jg short Literal;   /* al > 0, so literally */
                        asm je short String;    /* al == 0, so string */

Skip:                                           /* Otherwise skipping */
                        asm neg al;             /* Invert counter */
                        asm jo Eol;             /* Overflow, i.e. neg 128 */
                                                /* asm mov cl, al; /* Move counter */
                        asm add di, ax;         /* Advance the index. ah is 0! */

                        asm lodsb;              /* Get next image byte */
                        asm or al, al;          /* Query flags */
                        asm jl short Skip;      /* al < 0, so skipping */
                        asm je short String;    /* al == 0, so string */

Literal:                                        /* Otherwise literal */
                        asm mov cl, al;         /* Move counter */
                        asm rep movsb;          /* Copy cx bytes */
                        asm lodsb;              /* Get next image byte */
                        asm or al, al;          /* Query flags */
                        asm jl short Skip;      /* al < 0, so skipping */
                        asm jg short Literal;   /* al > 0, so literally */

String:                                         /* Otherwise string */
                        asm lodsb;              /* Get counter byte */
			asm mov cl, al;		/* Put counter to cl */
                        asm lodsb;              /* Get color byte into al */
                        asm rep stosb;          /* Store cx bytes of al */
                        asm lodsb;              /* Get next image byte */
                        asm or al, al;          /* Query flags */
                        asm jg short Literal;   /* al > 0, so literally */
                        asm jl short Skip;      /* al < 0, so skipping */
                        asm jmp short String;   /* Otherwise, string once more */
Eol:
		/*--same--as--mputz4p.c---*/
		asm mov di, bx;                 /* Restore ram index */
                asm add di, dx;                 /* Add BPERROW_CHAINED, advance ram index to next row */

		asm mov cx, bp;                 /* Restore row counter */
		asm loop RowLoop;

        asm pop bp;
	asm pop ds;
	return;
}