/* uputz4p.c  -  Decoding image in Z4Plane format to VRAM, UNCHAINED mode.
 *
 * Description:
 *   Uses the coding method, described in mputz4p.c
 * See Also:
 *      mputz4p.c
 * Functions:
 *      UputZ4Planes(), UZ4PRequest().
 * Portability: BORLANDC
 * Date: 05/20/92                               (c) erdy 1992
 * $Header: $
 */
#pragma inline
#include "far.h"
#include "vgaprefx.h"
#include "vgadrv.h"
#include "screen.h"

#ifndef VGA_UNCHAINED
#	undef BPERROW
#	define BPERROW BPERROW_UNCHAINED
#endif

#ifdef ZA_BLOCKED
static draw_request req;
void UputZ4Planes(char far *image, unsigned x, unsigned y, int rows)
{
        req.dr_seg = _segment(image);
        req.dr_imageo = _offset(image);
        req.dr_offset = y*BPERROW + (x>>2);
        req.dr_plane = x & 3;
        req.dr_rows = rows;
        UZ4PRequest(&req, 1);
}

void UZ4PRequest(draw_request *dp, int nreq)
{
        _A_setMapMask();       /* Point gate to Map Mask Register */

        _ES = Scdraw_seg;
	asm cld;
        asm mov cx, nreq;
ReqLoop:
        asm push cx;
	asm push ds;

#       if defined(__HUGE__)||defined(__LARGE__)||defined(__COMPACT__)
                /* Far data pointers */
                asm push es;
                asm les bx, dp;
                asm mov ax, es:[bx].dr_seg;
                asm mov ds, ax;
                asm mov si, es:[bx].dr_imageo;
                asm mov di, es:[bx].dr_offset;
                asm mov cx, es:[bx].dr_plane;
                asm mov bx, es:[bx].dr_rows;
                asm pop es;
#       else
                /* Near data pointers */
                asm mov bx, dp;
                asm mov si, [bx].dr_imageo;
                asm mov di, [bx].dr_offset;
                asm mov cx, [bx].dr_plane;
                asm mov dx, [bx].dr_rows;               /* DX now destroyed ! */
                asm mov ax, [bx].dr_seg;
                asm mov ds, ax;
                asm mov bx, dx;
#       endif

#else  ZA_BLOCKED
void UputZ4Planes(char far *image, unsigned x, unsigned y, int rows)
{
        _A_setMapMask();       /* Point gate to Map Mask Register */

        _ES = Scdraw_seg;
        _BX = rows;

	asm push ds;
	asm lds si, image;
	asm cld;
        asm mov ax, y;          /* Get argument */
        asm mov dx, BPERROW;
        asm mul dx;

        asm mov cx, x;          /* Get argument */
        asm mov di, cx;
        asm shr di, 1;          /* Divide di by 4 */
        asm shr di, 1;
        asm and cx, 3;          /* cx now contains plane number */
        asm add di, ax;
#endif ZA_BLOCKED

        /*
         * Common code for ZA_BLOCKED and !ZA_BLOCKED versions.
         * -----------------------------------------------------
         */

	asm mov ah, 0x10;
        asm shl ah, cl;
/*
 *  For starting offset 0:  (leftmost)
 *  #  cl  AH        AL      MapMask   di
 *  1  4   001.0000  0001    1         +0
 *  2  3   001.0000  0010    2         +0
 *  3  2   001.0000  0100    4         +0
 *  4  1   001.0000  1000    8         +0
 *
 *  For starting offset 1:
 *  #  cl  AH        AL      MapMask   di
 *  1  4   010.0000  0010    2         +0
 *  2  3   010.0000  0100    4         +0
 *  3  2   010.0000  1000    8         +0
 *  4  1   010.0000 10000
 *         000.0010  0001    1         +1
 *
 *  For starting offset 2:
 *  #  cl  AH        AL      MapMask   di
 *  1  4   100.0000  0100    4         +0
 *  2  3   100.0000  1000    8         +0
 *  3  2   100.0000 10000
 *         000.0100  0001    1         +1
 *  4  1   000.0100  0010    2         +0
 *
 *  For starting offset 3:  (rightmost)
 *  #  cl  AH        AL      MapMask   di
 *  1  4  1000.0000  1000    8         +0
 *  2  3  1000.0000 10000
 *         000.1000  0001    1         +1
 *  3  2   000.1000  0010    2         +0
 *  4  1   000.1000  0100    4         +0
 */
        asm push bp;
        asm mov cx, BITPLANES;
PlaneLoop:
        /*
	 * Planes loop. CX contains plane counter.
         * Scratch registers:
	 *      dx used to save bx, and to out instruction.
         */
        asm push cx;                    /* Save plane counter */

        /* Set the proper Map Mask */
        asm mov al, ah;                 /* Shifting bit */
	asm shr al, cl;                 /* Shift, according to (5 - plane #) */
	asm test al, 0xF;               /* Not enough ? */
        asm jnz  short Nowrap;
                asm inc di;             /* Wrap to next byte, i.e. next 4-group */
                asm shr ax, 1;          /* shr al,4;   shr ah,4 */
                asm shr ax, 1;
                asm shr ax, 1;
		asm shr ax, 1;
Nowrap:
        asm mov dx, VGA_SER_GATE;
        asm out dx, al;                 /* Select correct bitplane */

	asm push ax;                    /* Save shift bit in ah */
        asm push di;                    /* Save starting offset */
        asm mov  dx, bx;                /* Save row counter */

        asm mov  cx, bx;                /* Store row counter in cx */

                /*++++same+++as++mputz4p.c+++*/
RowLoop:
                /*
                 * Scanlines loop. CX contains nrows.
                 *
                 * Sequence of the alhorithm follows the most frequent image
                 * sequence: <skip>, <literal>, <skip/eol>.
                 * Thus, at least 3 jumps per line are saved.
                 *
                 * Scratch registers:
                 *      bx - saving the ram index (di)
                 *      bp - saving the loop counter (cx)
                 */
                asm mov bx, di;                 /* Save ram index */
                asm mov bp, cx;                 /* Save loop counter */
                asm xor ch, ch;                 /* Zero high byte, ch always zero */
                /* Loop until EOL */
LineLoop:
                        asm lodsb;              /* Get next image byte */
                        asm or al, al;          /* Query flags */
                        asm jg short Literal;   /* al > 0, so literally */
                        asm je short String;    /* al == 0, so string */

Skip:                                           /* Otherwise skipping */
                        asm neg al;             /* Invert counter */
                        asm jo Eol;             /* Overflow, i.e. neg 128 */
                        asm mov cl, al;         /* Move counter */
                        asm add di, cx;         /* Advance the index */

                        asm lodsb;              /* Get next image byte */
                        asm or al, al;          /* Query flags */
                        asm je short String;    /* al == 0, so string */
#if (BPERSCREEN/BITPLANES) > (SHAR_MAX-2)       /* <skip>, <skip> is available ? */
                        asm jl short Skip;      /* al < 0, so skipping */
#endif

Literal:                                        /* Otherwise literal */
                        asm mov cl, al;         /* Move counter */
                        asm rep movsb;          /* Copy cx bytes */
                        asm lodsb;              /* Get next image byte */
                        asm or al, al;          /* Query flags */
                        asm jl short Skip;      /* al < 0, so skipping */
#if (BPERSCREEN/BITPLANES) > (SHAR_MAX-2)       /* <literal>, <literal> is available ? */
                        asm jg short Literal;   /* al > 0, so literally */
#endif

String:                                         /* Otherwise string */
                        asm lodsb;              /* Get counter byte */
			asm mov cl, al;		/* Put counter to cl */
                        asm lodsb;              /* Get color byte into al */
                        asm rep stosb;          /* Store cx bytes of al */
                        asm lodsb;              /* Get next image byte */
                        asm or al, al;          /* Query flags */
                        asm jg short Literal;   /* al > 0, so literally */
#if (BPERSCREEN/BITPLANES) > (UHAR_MAX-1)       /* <string>, <string> is available ? */
                        asm jl short Skip;      /* al < 0, so skipping */
                        asm jmp short String;   /* Otherwise, string */
#else
                        asm jmp short Skip;      /* Otherwise, skipping */
#endif
                        /*asm jmp short LineLoop;*/
Eol:
		/*--same--as--mputz4p.c---*/
		asm mov di, bx;                 /* Restore ram index */
		asm add di, BPERROW;            /* Advance ram index to next row */

		asm mov cx, bp;                 /* Restore row counter */
		asm loop RowLoop;

	asm mov bx, dx;         /* Restore row counter */
	asm pop di;             /* Restore the initial offset */
        asm pop ax;             /* Restore shift bit in ah */
        asm pop cx;             /* Restore loop counter */
        asm loop PlaneLoop;

        asm pop bp;
	asm pop ds;

#       ifdef ZA_BLOCKED
                asm pop cx;
                asm loop FReqLoop;
                        return;
FReqLoop:
#               if defined(__HUGE__)||defined(__LARGE__)||defined(__COMPACT__)
                        _offset(dp) += sizeof(draw_request);
#               else
                        dp++;
#               endif
                goto ReqLoop;   /* Next draw request */
#       else  ZA_BLOCKED
                return;
#       endif ZA_BLOCKED
}