 '
 ' Process ^Z commands
 '

 DEFINT A-Z

'$INCLUDE: 'PROCESS.BI'
'$INCLUDE: 'PCL4VB.BI'
'$INCLUDE: 'VB_IO.BI'
'$INCLUDE: 'XYZ_IO.BI'
'$INCLUDE: 'XYMODEM.BI'
'$INCLUDE: 'ZMODEM.BI'

CONST FALSE = 0, TRUE = NOT FALSE
CONST NAK = &H15
CONST WHITE = 7
CONST BLACK = 0

DIM SHARED ThePort   AS INTEGER
DIM SHARED Protocol  AS STRING
DIM SHARED OneKflag  AS INTEGER
DIM SHARED NCGbyte   AS INTEGER
DIM SHARED BatchFlag AS INTEGER
DIM SHARED BaudRate  AS STRING
DIM SHARED Filename  AS STRING
DIM SHARED Streaming AS INTEGER
DIM SHARED DebugFlag AS INTEGER
DIM SHARED Logname   AS STRING
DIM SHARED FreeSpace AS INTEGER

SUB InitProcess(BYVAL Port AS INTEGER,Baud AS STRING)
  ThePort = Port
  BaudRate = Baud
  Protocol = "X"
  OneKflag = FALSE
  NCGbyte = NAK
  BatchFlag = FALSE
  Logname = "TERM.LOG" + CHR$(0)
  CALL xyzDefine(24,36,43,&H0070)
  CALL xyzOpenLog(SADD(Logname),SSEG(Logname))
END SUB

SUB WriteLeft(TheString AS STRING)
DIM MainRow AS INTEGER
DIM MainCol AS INTEGER
MainRow = CSRLIN
MainCol = POS(0)
VIEW PRINT 25 TO 25
COLOR BLACK, WHITE
LOCATE 25, 1, 1
PRINT TheString;
VIEW PRINT 1 TO 24
COLOR WHITE, BLACK
LOCATE MainRow, MainCol, 1
END SUB

SUB ShowStatus
DIM P AS STRING
DIM Msg AS STRING
P = STR$(1+ThePort)
Msg = " COM" + RIGHT$(P,LEN(P)-1) + " " + BaudRate + " " + Protocol + " ^Z for menu"
CALL WriteLeft(Msg)
END SUB

FUNCTION Process
  DIM C AS STRING
  DIM P AS STRING
  DIM KeyChar AS INTEGER
  PROCESS = FALSE
  IF TRUE THEN
  'quit if user types ^Z  IF TRUE THEN
    CALL ShowStatus
    CALL vbPutEOL
    CALL vbPutString(" Q)uit P)rotocol S)end R)eceive D)ebug: ")
    KeyChar = vbGetKey
    CALL vbPutChar(KeyChr)
    SELECT CASE UCASE$(CHR$(KeyChar))
      CASE "D"   'DEBUG
        DebugFlag = 1 - DebugFlag
        CALL xyParms(DebugFlag,18,3)
        CALL zmParms(DebugFlag,18)
        CALL vbDebug(DebugFlag)
        CALL vbPutEOLstr(" Debug =")
        CALL vbPutInteger(DebugFlag)
      CASE "Q"   'QUIT
        PRINT
        PRINT (" TERMINATING: User quitting.")
        RetCode = SioDone(ThePort)
        PROCESS = TRUE
        EXIT FUNCTION
      CASE "P"   'PROTOCOL
        CALL vbPutEOLstr(" X)modem Y)modem Z)modem: ")
        KeyChar = vbGetKey
        CALL vbPutChar(KeyChr)
        SELECT CASE UCASE$(CHR$(KeyChar))
          CASE "X"  'XMODEM
            Protocol = "X"
            OneKflag = FALSE
            NCGbyte = NAK
            BatchFlag = FALSE
            CALL vbPutEOLstr(" Protocol = XMODEM")
          CASE "Y"  'YMODEM
            Protocol = "Y"
            OneKflag = TRUE
            NCGbyte = ASC("C")
            BatchFlag = TRUE
            CALL vbPutEOLstr(" Protocol = YMODEM")
          CASE "Z"  'ZMODEM
            Protocol = "Z"
            IF BaudCode <= Baud19200 THEN
               Streaming = TRUE
            ELSE
               Streaming = FALSE
            END IF
            CALL vbPutEOLstr(" Protocol = ZMODEM")
          CASE ELSE
            CALL vbPutEOLstr(" Must Answer Z, Y or Z")
        END SELECT
        CALL ShowStatus
      CASE "R"  'Receive
        Filename = STRING$(15,0)
        FreeSpace = FRE(Filename)
        SELECT CASE LEFT$(Protocol,1)
          CASE "X"
            Flag = XmodemRx(ThePort, SADD(Filename), SSEG(Filename), NCGbyte)
          CASE "Y"
            Flag = YmodemRx(ThePort, NCGbyte)
          CASE "Z"
            Flag = ZmodemRx(ThePort, Streaming)
        END SELECT
      CASE "S"  'Send
        Filename = STRING$(15,0)
        FreeSpace = FRE(Filename)
        SELECT CASE LEFT$(Protocol,1)
          CASE "X"
            Flag = XmodemTx(ThePort, SADD(Filename), SSEG(Filename), OneKflag)
          CASE "Y"
            Flag = YmodemTx(ThePort, SADD(Filename), SSEG(Filename))
          CASE "Z"
            Flag = ZmodemTx(ThePort, SADD(Filename), SSEG(Filename), Streaming)
        END SELECT
      CASE ELSE
        CALL vbPutEOLstr(" Bad response")
     END SELECT
   END IF
 END FUNCTION
