/*****************************************************************************
                                APPSIG.C
                 A signature utility for Waffle systems
              Copyright by Roy M. Silvernail  June 1, 1991

This program is free.  You can't sell it or charge for it.
My copyright is there because I wrote it, not because I want to restrict
distribution.  Copy around and share, please!

APPSIG forms a wrapper around your editor, and offers the user the
opportunity to append a choice of signatures stored in his home dir as
*.sig files.

For Waffle usage, use this form of editor line:
(edit specific paths as appropriate)

appsig /access=1 /screen /command="c:\waffle\bin\appsig c:\user\%A q.exe %i"

Note that you may specify any editor with APPSIG.  It will search the
path to locate the program specified.  So, for BBStevie, you would use

bbstevie /access=1 /screen /command="c:\waffle\bin\appsig c:\user\%A
    bbstevie ! c:\user\%A %i"

(with no line break, of course)


Revision history:
1.01    06/01/91  moved directory to first arg, now passes variable args
				  to the editor.  Filename MUST be the final argument passed
				  to the editor from the _editors command.  Now looks for
                  *.sig in the user's home dir.  (thanks, Ralph!)

1.02    06/02/91  Cleaned up some pointer handling, and got rid of an
                  extra pointer used in a workaround.

1.03    08/22/91  Added sorting to the sig names, thanks to some
                  assistance from comp.lang.c and its fine citizens.

1.04    11/24/91  Cleaned up some NULL references that should have been
                  '\0'.

1.05    3/7/92    Changed the output to be 5 across the screen, instead
                  of a single column.
*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <dir.h>
#include <ctype.h>
#include <string.h>

char *fnarr[50];
struct ffblk r;                 /* used for DOS access */
static char *version = "1.05";
int sort_function(const void *a, const void *b);
void put_down(char *s);
int getdir(char *p);

void main(int argc, char *argv[]) {
    int sig_count,y;
	FILE *infile, *outfile;
	char buf[255], fname[80], home_dir[80];

    fname[0] = '\0';

	spawnvp(P_WAIT,argv[2], &argv[2]);

    sprintf(home_dir,"%s\\*.sig",argv[1]);

    sig_count = getdir(home_dir);

    printf("Appsig V%s by Roy M. Silvernail -- %s\n\n",version, __DATE__);

    for(y=0;y<sig_count;y++) {
        printf("%2d: %-8s%s",y+1,fnarr[y],(((y+1)%5) ? "\t" : "\n"));
    }

    y = 0;

    printf("\n(RET for 'sig', N for none) Sig to append? ");

    fgets(buf,sizeof(buf),stdin);

    if(buf[0] == 'n' || buf[0] == 'N') {
		printf("\nNo sig appended\n");
		exit(0);
	} else if(sscanf(buf,"%d ",&y) != 1) {
		sprintf(fname,"%s\\sig.sig",argv[1]);
	}

    if (fname[0] == '\0' && ((y > 0) && (y <= sig_count ))) {
		sprintf(fname,"%s\\%s.sig",argv[1],fnarr[y-1]);
	}

	if ((infile = fopen(fname,"r")) == NULL) {
		printf("\nFile not found: %s\n",fname);
		exit(0);
	}

    if ((outfile = fopen(argv[argc-1],"a")) == NULL) {
		printf("\nCan't open %s to append sig\n",fname);
		exit(0);
	}

    while (fgets(buf,sizeof(buf),infile)) {
		fputs(buf,outfile);
    }

	fcloseall();
    if (y) {
        printf("\nSig '%s' appended\n",fnarr[y-1]);
    } else {
        printf("\nSig 'sig' appended\n");
    }
	exit(0);
}


getdir(char *s) {
	int i = 0;

	if (findfirst(s, &r, 0) != 0) {  /* no sig files */
		exit(0);
	} else {
		strcpy(fnarr[i] = malloc(20),r.ff_name);
		put_down(fnarr[i]);
        *(strchr(fnarr[i++],'.')) = '\0';
	}

	while (!findnext(&r)) {
		strcpy(fnarr[i] = malloc(20), r.ff_name);
		put_down(fnarr[i]);
        *(strchr(fnarr[i++],'.')) = '\0';
	}

	strcpy(fnarr[i] = malloc(20), "\0");
    qsort(&fnarr[0], i,sizeof(fnarr[0]), sort_function);
	return(i);
}


void put_down(char *p) {
	while (*p) {
		if (isupper(*p))
			*p = tolower(*p);
		p++;
	}
}

int sort_function(const void *a, const void *b) {
    return (strcmp(*(char **)a, *(char **)b));
}
