/*
 * getopt.c - Taken off net.sources from Henry Spencer.  It is a public 
 *   domain getopt(3) like in System V.  It has been modified slightly,
 *   including making it look a little more ANSI-ish.
*/
#include <stdio.h>

#define   ARGCH    (int)':'
#define   BADCH    (int)'?'
#define   EMSG     ""

/* this is included because index is not on some UNIX systems 
*/
static char  *index (register char *s, register int c)
{
   while (*s)
      if (c == *s) return (s);
      else s++;
   return (NULL);
}

/*
 * get option letter from argument vector
 */
int  opterr = 1,	/* useless, never set or used */
     optind = 1,	/* index into parent argv vector */
     optopt;		/* character checked for validity */
char *optarg;		/* argument associated with option */

/* eject */

int getopt(int nargc, char **nargv, char *ostr)
{
   static char *place = EMSG;	/* option letter processing */
   register char *oli;		/* option letter list index */
   char   *index(char *s, int c);

   if ( !*place ) {		/* update scanning pointer */
      if ( optind >= nargc || *(place = nargv[optind]) != '-' || !*++place ) 
	 return(EOF);
      if ( *place == '-' ) {	/* found "--" */
         ++optind;
         return(EOF);
      }
   }	/* option letter okay? */
   if ( (optopt = (int)*place++) == ARGCH || !(oli = index(ostr,optopt)) ) {
      if ( !*place ) 
         ++optind;
      return(BADCH);
      
   }
   if ( *++oli != ARGCH ) {	/* don't need argument */
      optarg = NULL;
      if ( !*place ) 
	 ++optind;
   }
   else {			/* need an argument */
      if ( *place ) 
	 optarg = place;	/* no white space */
      else 
	 if (nargc <= ++optind) {	/* no arg */
            place = EMSG;
	    return(BADCH);
         }
         else optarg = nargv[optind];	/* white space */
            place = EMSG;
      ++optind;
   }
   return(optopt);         /* dump back option letter */
}

