#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <time.h>

#define PAGE 22
#define BIGSTR 192
#define XFACTOR 150
#define YFACTOR 210
#define ZFACTOR 230
#define ECHO_ENTER 1
#define NO_ECHO_ENTER 0
#define VALID_ALPHA " ~!@#$%^&()_+-=[]{};1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"

/*
                  File Areas:

     FILEDOOR - loaded from a certain current directory...
     filedoor.exe - can be in the path
     filedoor.cfg - points to file area dir and menu/config directory
                  - must be whereever loaded from.  Sample:
                       f:\bbsfiles\   - file areas.
                       d:\            - menu and xfer config files
                                filedoor.mm    main menu
                                filedoor.ma1   pre area menu
                                filedoor.ma2   post area menu/prompt
                                filedoor.mp1   pre protocol menu
                                filedoor.mp2   post protocol menu/prompt

     f:\bbsfiles   :
            (areaname).D  description
            1.D   FILE       (if priv is OK, get area description here.)
            (areaname).(privilege required.)
            1.9   DIRECTORY  (priv 9 required to use this area)
                  + file1.zip
                  + file2.zip
                  + DESCRIBE
                                + file1.zip  (description)
                                + file2.zip  (description)

        file xfer:
           user selects one character name.  This corresponds to
           external BAT file or program.

           for z or y, fname.ext (on send) is file with list of files.

           Download Example of download on COM1
              Z S FNAME.EXT 1
           Upload Example:
              Z R FNAME.EXT 1

           BAT files should be in same directory with menu files.

sending multiple files:
     dsz sz @C:files.lst
*/

union REGS regs;
#define FOSSIL int86(0x14, &regs, &regs);

int fossil_port;   /* 0 is com1, 1 is com2 */
int baud_rate;
long time_limit;
static int more;
static int local_mode;
static char filepath[BIGSTR];  /* path for file area */
static char menupath[BIGSTR];  /* path for menu files and temp files */
static char newpath[BIGSTR];   /* path for new files (uploads) */
static char protocols[BIGSTR];   /* list of valid protocols */
static char current_area[BIGSTR];
static char current_area_priv;
static char current_area_desc[BIGSTR];
unsigned todays_date;

long set_timer(long secs);

void dtr_low()
{
   if (local_mode) return;
   regs.h.ah = 0x06;
   regs.h.al = 0;
   regs.x.dx = fossil_port;
   FOSSIL;
}

void die(rc, msg)
int rc;
char *msg;
{
   fosputs(msg);
   if (rc == 9) {
        fosputs("Dropping Carrier...\n");
        dtr_low();
   }
   exit(rc);
}

int dcd_status()
{
   if (local_mode) return(0x80);
   regs.h.ah = 0x03;
   regs.x.dx = fossil_port;
   FOSSIL;
   return (regs.h.al & 0x80);
}

int remove_fossil()
{
   if (local_mode) return(0x80);
   regs.h.ah = 0x05;
   regs.x.dx = fossil_port;
   FOSSIL;
}
int install_fossil()
{
   if (local_mode) return(0x80);
   regs.h.ah = 0x04;
   regs.x.dx = fossil_port ;
   regs.x.bx = 0;
   FOSSIL;
}

/* rec_fossil returns -1 or character on port */
int rec_fossil()
{

   if (local_mode) return(-1);
   regs.h.ah = 0x0c;
   regs.x.dx = fossil_port;
   FOSSIL;
   if (regs.x.ax == -1) return(-1);
   regs.h.ah = 0x02;
   regs.x.dx = fossil_port;
   FOSSIL;
   return(regs.h.al);
}

int put_fossil(comchar)
int comchar;
{
   if (local_mode) return(comchar);
   regs.h.ah = 0x01;
   regs.h.al = comchar;
   regs.x.dx = fossil_port;
   FOSSIL;
   return(comchar);
}

int flush_fossil()
{
   if (local_mode) return(0);
   regs.h.ah = 0x0A;
   regs.x.dx = fossil_port;
   FOSSIL;
}

long
set_timer(long secs)
{
   long ltime;
   time(&ltime);
   ltime = ltime + secs;
   return(ltime);
}
void
sleep(long secs)
{
   long ltime;
   ltime = set_timer(secs);
   while (set_timer(0) < ltime) ;

}

char *fosgets(int len, char *allowed, int enterflg)
{
        static char command[BIGSTR];
        char *cmdstr;
        int inkey;
        long timer;
        int i = 0;
        if (len == 0) len = BIGSTR-1;
        flush_fossil();
        timer = set_timer(90);
        do  {
                if (!dcd_status()) {
                        die(2,"\n\nExiting File System... Carrier lost.\n\n");
                }
                if (set_timer(0) > timer) {
                        die(2,"\n\nExiting File System... Idle time out.\n\n");
                }
                if (set_timer(0) > time_limit) {
                        die(9,"\n\nExiting File System... Time on BBS expired.\n\n");
                }
                if (kbhit())
                        inkey = getch();
                else
                        inkey = rec_fossil();

                if (inkey != -1) {

                   timer = set_timer(90);
                   inkey = inkey & 0x7f;

                   switch (inkey) {
                       case 8 :            /* backspace */
                           i-=1;
                           if (i >= 0) {
                                   putchar(put_fossil(8));
                                   putchar(put_fossil(' '));
                                   putchar(put_fossil(8));
                           } else i = 0;
                           break;
                       case 3    :         /* control C */
                           i = 0;
                           fosputs(" ");
                           break;
                       case 0x0A :         /* cr/lf     */
                       case 0x0D :
                           if (enterflg == ECHO_ENTER) fosputs("\n");
                       case -1   :         /* timeout */
                           break;
                       default :
                           if (allowed[0]) {
                              if (strrchr(allowed, inkey))
                                 putchar(put_fossil(command[i++] = inkey));
                              else
                                 put_fossil(7);
                           } else
                              putchar(put_fossil(command[i++] = inkey));
                   }
                }

                if (i >= BIGSTR-1) {
                        fosputs("\n  Too many characters entered...\n");
                        inkey = 3;
                }

        } while ((inkey != 0x0D) && (inkey != 0x0A)
            && (inkey != 3) && (i<len));
                                             /* enter or ctrl c */
        if (inkey == 3) {
           command[0] = 3;
           i = 1;
        } else
           if (((inkey == 0x0D) || (inkey == 0x0A)) &&
              (enterflg == NO_ECHO_ENTER) && (i==0)) command[i++] = '\n';

        command[i] = '\0';

        cmdstr = command;
        while ((*cmdstr == ' ') && (strlen(cmdstr) > 1)) cmdstr++;
        return(cmdstr);
}

char
more_prompt(prompt)
char *prompt;
{
        char ch;
        int i, j;
        more = 0;
        fosputs(prompt);
        ch = fosgets(1,"YyNn ",NO_ECHO_ENTER)[0];
        if (ch == '\n') j = strlen(prompt); else j = strlen(prompt) + 1;
        if (ch == 3) ch = 'N';
        if (ch) for (i=0 ; i<j; i++) {
            putchar(put_fossil(8));
            putchar(put_fossil(' '));
            putchar(put_fossil(8));
        }
        if (ch == ' ')
            more = PAGE-1;
        else
            more = 0;
        return(toupper(ch));
}

int fosputs(text)
char *text;
{
        while (*text) {
                printf("%c",*text);
                if (rec_fossil() == 3)
                   return(0);
                if (*text == '\n') {
                   put_fossil(0x0D);
                   put_fossil(*text);
                   more++;
                   if (more == PAGE) {
                      more = 0;
                      if (more_prompt("[More? y, n, <space>] : ") == 'N')
                         return(0);
                   }
                } else put_fossil(*text);
                text++;
        }
        return(1);
}

int fixup(str)
char *str;
{
        int i;
        for (i = strlen(str)-1 ; i>=0; i--)
                if ((str[i] == 0x0D) || (str[i] == 0x0A) || (str[i] == ' '))
                        str[i] = '\0';
}

long
exist(filename)
char *filename;
{
        struct find_t find, *finda;

        finda = &find;
        if( !_dos_findfirst( filename, _A_NORMAL, &find ) ){
                return(finda->size);
        }else
                return(0);

}

char *drivename(wholename)
char *wholename;
{
   static char path[80];
   int i, last=0;
   for (i=0;(i<strlen(wholename)) && (wholename[i] != ':'); i++) ;
   path[0] = '\0';
   if (i<strlen(wholename)) strncpy(path,wholename,i+1);
   path[i+1] = '\0';
   if (path[0] == ':') path[0] = '\0';
   return(path);
}
char *pathname(wholename)
char *wholename;
{
   static char path[80];
   int i, last=0;
   for (i=0; i<strlen(wholename); i++)
      if (wholename[i] == '\\')
         last = i;
   path[0] = '\0';

   if ((wholename[last] =='\\') && ((wholename[last-1]==':') || last==0))
      last++;
   if (wholename[last]==':')
      last = 0;

   strncpy(path, wholename, last);
   path[last] = '\0';
   return(path);
}

int getconfig()
{
        FILE *cfg;
        char line[BIGSTR];
        char *fname;
        int fdrive;
        if (!(fname = getenv("FILEDOOR"))) return(0);
        if (cfg = fopen(fname,"r")) {
                strcpy (filepath, fgets(line, BIGSTR-1, cfg));
                strcpy (menupath, fgets(line, BIGSTR-1, cfg));
                strcpy (newpath,  fgets(line, BIGSTR-1, cfg));
                strcpy (protocols,  fgets(line, BIGSTR-1, cfg));
                fixup (filepath);
                fixup (menupath);
                fixup (newpath);
                fixup (protocols);
                fclose(cfg);
                if (fdrive = drivename(filepath)[0])
                   _chdrive( fdrive = (toupper(fdrive) - 'A')+1 );
                chdir(pathname(filepath));
                return(1);
        } else return(0);
}

int showmenu(str)
char *str;
{
        FILE *menu;
        char line[BIGSTR], fname[BIGSTR], *findit;
        int i;
        more = 0;
        sprintf(fname, "%s%s%s", menupath, "FILEDOOR.", str);
        if (menu = fopen(fname,"r")) {
                while (fgets(line, BIGSTR-1, menu)) {
                    for (i=0; i<strlen(line); i++)
                            if (findit = strrchr(line, '~')) *findit = '\0';
                    if (!fosputs(line)) break;
                }
                fclose(menu);
        }
}

char
*bbs_area_dir(search)
char *search;
{
        static char apath[BIGSTR];
        if (search[0])
           sprintf(apath, "%s.%c\\%s", current_area, current_area_priv, search);
        else
           sprintf(apath, "%s.%c\\*.*", current_area, current_area_priv);
        return(apath);
}

char
*bbs_file(filename)
char *filename;
{
        static char apath[BIGSTR];
        sprintf(apath, "%s.%c\\%s", current_area, current_area_priv,
                   filename);
        return(apath);
}

char
*bbs_file_desc(filename)
char *filename;
{
        static char apath[BIGSTR];
        sprintf(apath, "%s.%c\\DESCRIBE\\%s", current_area,
                   current_area_priv, filename);
        return(apath);
}
void
print_time(char *fname, long fsize, char opt)
{
        static char workstr[BIGSTR];
        long worktime, worktime2, factor;
        switch (opt) {
                case 'X' :
                factor = XFACTOR;
                break;
                case 'Y' :
                factor = YFACTOR;
                break;
                case 'Z' :
                factor = ZFACTOR;
                break;
                default  :
                factor = 999999;
                ;
        }
        worktime = ((fsize*240) / ((baud_rate/10)*factor)) / 60;
        sprintf(workstr, "File %s in area %s : %ld bytes, %ld minute(s)\n", strupr(fname), current_area, fsize, worktime+1);
        fosputs(workstr);
        if (opt == 'X') {
           factor = ZFACTOR;
           worktime2 = worktime - (((fsize*240) / ((baud_rate/10)*factor)) / 60);
           if (worktime2 > 1) {
              sprintf(workstr, "Using ZMODEM would SAVE %ld minute(s)\n", worktime2);
              fosputs(workstr);
           }
           factor = YFACTOR;
           worktime2 = worktime - (((fsize*240) / ((baud_rate/10)*factor)) / 60);
           if (worktime2 > 1) {
              sprintf(workstr, "  And YMODEM would SAVE %ld minute(s)\n", worktime2);
              fosputs(workstr);
           }
        }
}

long
find_file(char *fname, int priv)
{
       struct find_t afind, *afinda;
       long fsize;
       char *p, savearea[BIGSTR];
       strcpy(savearea, current_area);
       afinda = &afind;
       /* FIRST CHECK THE CURRENT AREA!!! - allows duplicate file names */
       if (fsize = exist(bbs_file(fname))) return(fsize);
       if( !_dos_findfirst( "*.*", _A_SUBDIR, &afind ) )
       {
           if ((afinda->attrib & _A_SUBDIR)  && (afinda->name[0] != '.')) {
              p = strpbrk(afinda->name, ".");
              p[0] = '\0';
              /* only look in an current area once */
              if ( (stricmp(savearea, afinda->name)) && (areaok(afinda->name, priv))) {
                 strcpy(current_area, afinda->name);
                 if (fsize = exist(bbs_file(fname))) return(fsize);
              }
           }
           while( !_dos_findnext( &afind ) )
              if ((afinda->attrib & _A_SUBDIR) && (afinda->name[0] != '.')){
                 p = strpbrk(afinda->name, ".");
                 p[0] = '\0';
                 /* only look in an current area once */
                 if ( (stricmp(savearea, afinda->name)) && (areaok(afinda->name, priv))) {
                    strcpy(current_area, afinda->name);
                    if (fsize = exist(bbs_file(fname))) return(fsize);
                 }
              }
       }
       return(0);
}

int
add_file_to_list(int append_flag, char *filename, char popt, int priv)
{
        char listfname[BIGSTR];
        char workarea[BIGSTR];
        FILE *listf;
        int apriv;
        long fsize;

        sprintf(listfname, "%s%s", menupath, "FILEDOOR.FLS");
        if (append_flag)
                listf = fopen(listfname, "a");
        else
                listf = fopen(listfname, "w");

    /* SALZO1 CODE HERE TO SCAN ALL DIRECTORIES */
        strcpy(workarea, current_area);
        apriv = current_area_priv;
        if (fsize = find_file(filename, priv)) {
                fprintf(listf, "%s\n", bbs_file(filename));
                fclose(listf);
                print_time(filename, fsize, popt);
                current_area_priv = apriv;
                strcpy(current_area, workarea);
                return(1);
        }
        sprintf(listfname, "** FILE \"%s\" NOT FOUND **\n", strupr(filename));
        fosputs(listfname);
        fclose(listf);
        current_area_priv = apriv;
        strcpy(current_area, workarea);
        return(0);
}

/*
           Download Example of download on COM1
              d:\Z S FNAME.EXT 1
*/
void
download(protocol, filename)
char protocol;
char *filename;
{
        char commandline[BIGSTR];
        sprintf(commandline, "%s%c S %s %d",
                menupath, protocol, filename, fossil_port+1);
        fosputs("\nPrepare system for DOWNLOAD now.\n\n");
        sleep(2);       /* try to fix screwed up text problem */
        remove_fossil();
        if (!local_mode) system(commandline);
        install_fossil();
        sleep(2);       /* try to fix screwed up text problem */
        while (rec_fossil() != -1) ; /* flush uart */
        put_fossil(7);
        sleep(1);       /* try to fix screwed up text problem */
        put_fossil(7);
}

void
upload(protocol, filename)
char protocol;
char *filename;
{
        char commandline[BIGSTR];
        FILE *describe;
        long time1, time2;
        sprintf(commandline, "%s%s", newpath, filename);
        if (!exist(commandline)) {
           sprintf(commandline, "%s%s\\%s", newpath, "DESCRIBE", filename);
           if (describe = fopen(commandline, "w")) {
               fosputs("Enter description : ");
               strcpy(commandline, fosgets(50, VALID_ALPHA, ECHO_ENTER));
               if (commandline[0] == 3) {
                  fclose(describe);
                  return;
               }
               fprintf(describe, "%s", commandline);
               fclose(describe);
           }
           sprintf(commandline, "%s%c R %s%s %d",
               menupath, protocol, newpath, filename, fossil_port+1);
           fosputs("\nInitiate UPLOAD now.\n\n");
           sleep(2);       /* try to fix screwed up text problem */
           remove_fossil();
           time1 = set_timer(0);
           if (!local_mode) system(commandline);
           install_fossil();
           time2 = set_timer(0);
           time_limit = time_limit + (time2 - time1);
           put_fossil(7);
           put_fossil(7);
           put_fossil(7);
        } else {
           fosputs("\n** CANNOT CREATE FILE - MAY ALREADY EXIST **\n");
        }
}

char
*filedesc(filename)
char *filename;
{
        static char desc[BIGSTR];
        FILE *areaf;
        int i;
        desc[0] = '\0';
        if (areaf = fopen(bbs_file_desc(filename), "r")) {
                fgets(desc, 50, areaf);
                for (i = strlen(desc)-1 ; i>=0; i--)
                    if ((desc[i] == 0x0D) || (desc[i] == 0x0A))
                         desc[i] = '\0';
                fclose(areaf);
        }
        return(desc);
}

/* Takes unsigned date in the format:               fedcba9876543210
 * d=1-31, m=1-12, y=0-119 (1980-2099)              yyyyyyymmmmddddd
 * Changes to a 9-byte string:                      mm/dd/yy
 */
char *datestr( unsigned d, char *buf )
{
    sprintf( buf, "%2d/%02.2d/%02.2d",
             (d >> 5) & 0x0f, d & 0x1f, (d >> 9) + 80 );
    return buf;
}

unsigned int_date(unsigned d)
{
    unsigned temp;
    temp =  ((d >> 9) * 360) + (((d >> 5) & 0x0f) * 30) + min ((d & 0x1f), 30);
/*    printf("date: %d\n", temp);*/
    return(temp);
}


int
print_file_info(filename)
char *filename;
{
        struct find_t find, *finda;
        long size;
        unsigned date;
        char fname[BIGSTR], dates[10];
        finda = &find;
        if( !_dos_findfirst( bbs_file(filename), _A_NORMAL, &find ) ) {
                size = (finda->size / 1025) + 1 ;
                date = finda->wr_date;
        }else{
                size = 0;
                date = 0;
        }
        sprintf(fname, " %-12s  %6s  %3ldk  %s\n", filename, datestr(date, dates),
        size, filedesc(filename));
        return(fosputs(fname));
}

void
make_ref()
/* KLUGE to get today's file write date */
{
        FILE *ref;
        struct find_t find, *finda;
        char temp[BIGSTR];
        todays_date = 0xFFFF;
        sprintf(temp, "%s%s", menupath, "FILEDOOR.REF");
        ref = fopen(temp, "w");
        fclose(ref);
        finda = &find;
        if( !_dos_findfirst( temp, _A_NORMAL, &find ) )
            todays_date = int_date(finda->wr_date) ; /* 1/2/91 */
        /*    todays_date = finda->wr_date; */
}

int areaok(tmp, priv)
char *tmp;
int priv;
{
    struct find_t find, *finda;
    char timp;
    char work[BIGSTR];

    finda = &find;
    strcpy(work, tmp);
    strcat(work, ".*");
    if ( !_dos_findfirst( work, _A_SUBDIR, &find ) )
        if ((finda->attrib & _A_SUBDIR) &&
           (((timp = strpbrk(finda->name, ".")[1])-'0') <= priv)){
           current_area_priv = timp;
           return(1);
           }
        else
           if ( !_dos_findnext( &find ) )
              if ((finda->attrib & _A_SUBDIR) &&
                 (((timp = strpbrk(finda->name, ".")[1])-'0') <= priv)){
                 current_area_priv = timp;
                 return(1);
                 }
    return(0);
}


int
list_area_engine(unsigned age, char *search, char *init, int *found)
{
    struct find_t find, *finda;
    finda = &find;
       if (!age) age = 0xFFFF;
       if( !_dos_findfirst( bbs_area_dir(search), _A_NORMAL, &find ) )
       {
           fosputs(init);

           if ((todays_date - int_date(finda->wr_date) <= age)) {
              *found = 1;
              if (!print_file_info(finda->name)) return(0);
           }
           while( !_dos_findnext( &find ) ) {
              if ((todays_date - int_date(finda->wr_date) <= age)) {
                 *found = 1;
                 if (!print_file_info(finda->name)) return(0);
              }
           }
       }
       return(1);
}


void
list_area(unsigned age, char *search, char *init, int priv)
{
    struct find_t afind, *afinda;
    int found;
    int apriv;
    char *p;
    char work_area[BIGSTR], workbuff[BIGSTR];
    afinda = &afind;

    found = 0;
    strcpy(work_area, current_area);
    apriv = current_area_priv;
    if (!((age) || (search[0]))) {  /*do the usual stuff*/

       if (!list_area_engine(age, search, init, &found)) goto cleanup;

    } else { /* NEW SEARCH SALZO search each area for the files */
       if( !_dos_findfirst( "*.*", _A_SUBDIR, &afind ) )
       {
           if ((afinda->attrib & _A_SUBDIR)  && (afinda->name[0] != '.')) {
              p = strpbrk(afinda->name, ".");
              p[0] = '\0';
              if (areaok(afinda->name, priv)) {
                 strcpy(current_area, afinda->name);
                 sprintf(workbuff, "** Looking in area %s...\n", current_area);
                 if (!fosputs(workbuff)) goto cleanup;
                 if (!list_area_engine(age, search, init, &found)) goto cleanup;
              }
           }
           while( !_dos_findnext( &afind ) )
              if ((afinda->attrib & _A_SUBDIR) && (afinda->name[0] != '.')){
                 p = strpbrk(afinda->name, ".");
                 p[0] = '\0';
                 if (areaok(afinda->name, priv)) {
                    strcpy(current_area, afinda->name);
                    sprintf(workbuff, "** Looking in area %s...\n", current_area);
                    if (!fosputs(workbuff)) goto cleanup;
                    if (!list_area_engine(age, search, init, &found)) goto cleanup;
                 }
              }
       }
    }   /* end of new code SALZO */

    if (!found)
       fosputs("\n** No files found **\n");
    else
       if (more > 0) more_prompt("\nPress Enter to continue...");
cleanup:
    strcpy(current_area, work_area);
    current_area_priv = apriv;
}

char
*areadesc(area)
char *area;
{
        static char desc[BIGSTR];
        char fname[BIGSTR];
        FILE *areaf;
        int i;
        desc[0] = '\0';
        sprintf(fname, "%s.%s", area, "D");
        if (areaf = fopen(fname, "r")) {
                fgets(desc, 60, areaf);
                for (i = strlen(desc)-1 ; i>=0; i--)
                    if ((desc[i] == 0x0D) || (desc[i] == 0x0A))
                         desc[i] = '\0';
                fclose(areaf);
        }
        return(desc);
}

int
print_area_info(area, priv)
char *area;
int priv;
{
        int apriv;
        char fname[BIGSTR], *p;

        p = strpbrk(area, ".");
        apriv = p[1] - '0';
        p[0] = '\0';

        if (apriv > priv) return(0);

        sprintf(fname, "  %-8s  -  %s\n", area, areadesc(area));
        return(fosputs(fname));
}

showareas(priv)
int priv;
{

  /*
  get first dir, extract name, check priv, show if ok, show name.d
  contents as description of the area - print only enough bytes to fit on
  line.
  do the same for each successive directory.
  */
    struct find_t find, *finda;
    char dirname[BIGSTR];
    FILE *AREA;

    finda = &find;
    if( !_dos_findfirst( "*.*", _A_SUBDIR, &find ) )
    {
        if ((finda->attrib & _A_SUBDIR)  && (finda->name[0] != '.'))
           print_area_info(finda->name, priv) ;
        while( !_dos_findnext( &find ) )
           if ((finda->attrib & _A_SUBDIR) && (finda->name[0] != '.'))
              print_area_info(finda->name, priv) ;
    }
}

int
select_area(priv)
int priv;
{
   int tries;
   char workbuff[BIGSTR];
   tries = 0;
   do {
      showmenu("MA1");
      showareas(priv);
      showmenu("MA2");
      strcpy (workbuff, fosgets(0,
      "~!@#$%^&()_+-=[]{};1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ",
         ECHO_ENTER));
      if ((workbuff[0] == 0) || (workbuff[0] == 3))
         return(0);
      if (((workbuff[0] == 'q') || (workbuff[0] == 'Q')) &&
               (!workbuff[1]))
         return('Q');
      if (!areaok(workbuff, priv)) {
         fosputs("\n** INVALID AREA ENTERED **\n");
         tries++;
         if (tries > 4) die(5, "\n\nExiting File System... Failure to select area.\n\n");
      }
   } while (!areaok(workbuff, priv));

   strcpy (current_area, workbuff);
   strcpy(current_area_desc, areadesc(strupr(current_area)));
   return(1);
}

void
ansi_cls(char *term)
{
   char workbuff[BIGSTR];
   if (toupper(term[0]) == 'V') {  /* if vt100, clear the screen*/
      sprintf(workbuff, "%c[2J", 0x1B);
      fosputs(workbuff);
   }
}

main(argc, argv, envp)
   int argc;
   char *argv[];
   char **envp;
{
   static char userid[80], term[80], init_area[80];
   char filechars[BIGSTR];
   char workbuff[BIGSTR];
   char workarea[BIGSTR];
   unsigned opt;
   int filecount;
   long fsize, tmpl;
   int apriv;
   int priv=0;
   fossil_port = 0;
   baud_rate = 2400;

   if ((argc>=2) && (**++argv=='?')) {
      printf("FILEDOOR, usage: filedoor -p port -u userid -t termtype -l priv -Z\n");
      printf("          ports are 1, 2, 3, 4   \n");
      exit(1);
   } else {

      /* Get all the dash (-) options.  */
      while (**argv=='-') {
         switch (*++*argv) {
         case 'l':
         case 'L':
            if (!(*++*argv)) {
               argv++;
               argc--;
               if (argc <= 1) {
                  printf("No level entered.  Enter FILEDOOR ? for help.\n");
                  exit(1);
               }
            }
            priv = atoi(*argv);
            printf("Level         : %d\n",priv);
            break;
         case 'u':
         case 'U':
            if (!(*++*argv)) {
               argv++;
               argc--;
               if (argc <= 1) {
                  printf("No userid entered.  Enter FILEDOOR ? for help.\n");
                  exit(1);
               }
            }
            strcpy(userid, *argv);
            printf("USERID        : %s\n",userid);
            break;
         case 'a':
         case 'A':
            if (!(*++*argv)) {
               argv++;
               argc--;
               if (argc <= 1) {
                  printf("No init area entered.  Enter FILEDOOR ? for help.\n");
                  exit(1);
               }
            }
            strcpy(init_area, *argv);
            printf("Init Area        : %s\n",init_area);
            break;
         case 't':
         case 'T':
            if (!(*++*argv)) {
               argv++;
               argc--;
               if (argc <= 1) {
                  printf("No term type entered.  Enter FILEDOOR ? for help.\n");
                  exit(1);
               }
            }
            strcpy(term, *argv);
            printf("TERMINAL      : %s\n",term);
            break;
         case 'p':
         case 'P':
            if (!(*++*argv)) {
               argv++;
               argc--;
               if (argc <= 1) {
                  printf("No port entered.  Enter FILEDOOR ? for help.\n");
                  exit(1);
               }
            }
            fossil_port=atoi(*argv) - 1 ;
            printf("Port          : %d\n",fossil_port);
            if ((*argv[0] < '0') || (*argv[0] > '9') || (strlen(*argv) > 1)) {
               printf("Invalid COM port.  0 thru 9 are supported.\n");
               exit(1);
            }
            break;
         case 'b':
         case 'B':
            if (!(*++*argv)) {
               argv++;
               argc--;
               if (argc <= 1) {
                  printf("No Baud Rate Entered.  Enter FILEDOOR ? for help.\n");
                  exit(1);
               }
            }
            baud_rate=atoi(*argv);
            printf("Baud Rate     : %d\n",baud_rate);
            break;
         case 'o':
         case 'O':
            if (!(*++*argv)) {
               argv++;
               argc--;
               if (argc <= 1) {
                  printf("No time limit entered.  Enter FILEDOOR ? for help.\n");
                  exit(1);
               }
            }
            time_limit = (long) atoi(*argv) * 60;
            printf("Seconds       : %ld\n", time_limit);
            time_limit = set_timer(time_limit);
            printf("Time Now      : %ld\n",set_timer(0));
            printf("Time Out At   : %ld\n",time_limit);
            break;
         case 'z':
         case 'Z':
            local_mode = 1;
            break;
         default:
            ;
         } /* endswitch */
         argv++;  /* point to next arg */
         argc--;  /* argc needs to reflect positional arg count */
      }  /* end while */
   }

   if (getconfig()) {
   ansi_cls(term);
   showmenu("M00");
   if (userid[0]) userid[0] = toupper(userid[0]);
   fosputs(userid);fosputs("!\n");

   strcpy(filechars,"abcdefghijklmnopqrstuvwxyz");
   strcat(filechars,"ABCDEFGHIJKLMNOPQRSTUVWXYZ");
   strcat(filechars,"1234567890-=!@#$%^&*?()_+.;\"'|][{}");

   make_ref();

   /* go immediately to select area... then into the loop. */

/* new stuff 1/13/91 */
   if ((init_area[0] != '\0') && areaok(init_area, priv)) {
      strcpy (current_area, init_area);
      strcpy(current_area_desc, areadesc(strupr(current_area)));
   } else {
      if (!(opt = select_area(priv)) || (opt == 'Q')) die(5, "\n\nExiting File System... No area selected.\n\n");
   }


   while (1) {
        /* reset 'more' counter */
        more = 0;
        tmpl = time_limit - set_timer(0);
        tmpl = tmpl / 60;
        sprintf(workbuff, "\nYou have %ld minutes remaining.\n", tmpl);
        fosputs(workbuff);
        sprintf(workbuff, "\nArea %s - %s\n", current_area, current_area_desc);
        fosputs(workbuff);
        showmenu("MM"); /*  show main menu */
        opt = fosgets(1,"qQaAfFlLuUdDnN?hH", ECHO_ENTER)[0];
        fosputs("\n");
        switch (opt) {
            case 'Q':
            case 'q':
                showmenu("MQ1");
                opt = fosgets(1, "QqAaGg", ECHO_ENTER)[0];
                fosputs("\n");
                more = 0;
                switch (opt=toupper(opt)) {
                case 'A':
                   if (select_area(priv) == 'Q') exit(0);
                   break;
                case 'G':       /* drop dtr, hang up fone... */
                   fosputs("\n\nTHANKS for Calling!!!\n\n");
                   dtr_low();
                case 'Q':
                   exit(0);
                default:
                   ;
                }
                break;
            case 'A':
            case 'a':
                if (select_area(priv) == 'Q') exit(0);
                /* get area choice */
                /* log area choice, if not valid - display message */
                /* not valid means either does not exist or priv too low */
                break;
            case 'F':
            case 'f':
                more = 0;
                /* ask for search criteria */
                fosputs("\nEnter filename search criteria (eg, *.zip) : ");
                /* search current area , list files with description */
                strcpy(workbuff, fosgets(0, filechars, ECHO_ENTER));
                if (workbuff[0] == 3) break;
                if (!workbuff[0]) strcpy(workbuff, "*.*");
                list_area(0, workbuff, "", priv);
                /* use 'more' after each PAGE lines */
                break;
            case 'L':
            case 'l':
                more = 0;
                list_area(0, "", "\n", priv);
                break;
            case 'N':
            case 'n':
                more = 0;
                /* ask for number of days.  Compare (today-n) with date
                   of each file's **directory**.  If file's directory
                   date is greater, list that file in current area.
                   Use first found area with correct priv if no area
                   logged */
                fosputs("\nEnter file age (in days) to include in search : ");
                strcpy(workbuff, fosgets(0, "1234567890", ECHO_ENTER));
                if (workbuff[0] == 3) break;
                opt = atoi(workbuff);
                fosputs("Enter filename search criteria (eg, *.zip) : ");
                strcpy(workbuff, fosgets(0, filechars, ECHO_ENTER));
                if (workbuff[0] == 3) break;
                if (!workbuff[0]) strcpy(workbuff, "*.*");
                list_area(opt, workbuff, "", priv);
                break;
            case 'D':
            case 'd':
                more = 0;
                filecount = 0;
                /* ask for protocol */
                showmenu("MP1");
                opt = fosgets(1, protocols, ECHO_ENTER)[0];
                if ((!opt) || (opt==3)) break;
                /* fosputs("\nEnter a file name for download : ");*/
                /* fosputs("\nSpecify a file name from the current area and press <enter> : ");*/
                fosputs("\nSpecify a file name from any area and press <enter> : ");
                strcpy(workbuff, fosgets(0, filechars, ECHO_ENTER));
                if (workbuff[0] == 3) break;
                switch (opt=toupper(opt)) {
                    case 'X':
                /* SALZO1 CODE HERE TO SCAN ALL DIRECTORIES */
                        strcpy(workarea, current_area);
                        apriv = current_area_priv;
                        if (fsize = find_file(workbuff, priv)) {
                           print_time(workbuff, fsize, 'X');
                           download(opt, bbs_file(workbuff));
                        } else
                           fosputs("** FILE NOT FOUND **\n");
                        current_area_priv = apriv;
                        strcpy(current_area, workarea);
                        break;
                    case 'Z':
                    case 'Y':
                        filecount += add_file_to_list(0, workbuff, (char) opt, priv);
                        do {
                           more = 0;
                           /* sprintf(workbuff, "File %d (blank begins download) : ", filecount+1);*/
                           sprintf(workbuff, "Specify file #%d (blank to begin download) and press <enter> : ", filecount+1);
                           fosputs(workbuff);
                           strcpy(workbuff, fosgets(0, filechars, ECHO_ENTER));
                           if (workbuff[0] == 3) break;
                           if (workbuff[0]) filecount += add_file_to_list(1, workbuff, (char) opt, priv);
                        } while (workbuff[0]);
                        if (workbuff[0] == 3) break;
                        sprintf(workbuff, "%s%s", menupath, "FILEDOOR.FLS");
                        if (filecount)
                           download(opt, workbuff);
                        else
                           fosputs("\n** No files to DOWNLOAD **\n");
                        break;
                    default:
                    ;
                }
                /* ask for file name, search for file if not found, ask
                   again until null string entered.  */
                /* if Y, B, or Z, ask for multiple files, storing in
                        file menudir\download.lst */
                /* if X, just ask for one file name */
                break;
            case 'U':
            case 'u':
                more = 0;
                /* ask for protocol */
                showmenu("MP1");
                opt = fosgets(1, protocols, ECHO_ENTER)[0];
                if ((!opt) || (opt==3)) break;
                fosputs("\nEnter a file name for upload : ");
                strcpy(workbuff, fosgets(0, filechars, ECHO_ENTER));
                if (!workbuff[0] || (workbuff[0] == 3)) break;
                upload(opt, workbuff);
                /* upload to new file area only.  NEW is new file area */
                /* ask for file name and description.  Create necessary */
                /* file/directory structure */
                break;
            case 'h':
            case 'H':
            case '?':
                ansi_cls(term);
                more = 0;
                showmenu("MH1");
                if (more > 0) more_prompt("\nPress Enter to continue...");
                ansi_cls(term);
                /*fosputs(userid);fosputs("!\n");*/
                break;
            default :
                ;
        }
   /*  if (opt == 'x') system("c:\\util\\dsz port 2 sx c:\\x10\\fossil\\filedoor.mm") ;*/
   }} else fosputs("\n\nfiledoor:  CANT FIND CONFIGURATION FILE!!!\n\n");
   exit(3);
}
