
/*
 *
 *  $Id: poll.c 1.0 91/08/14 13:21:14 Rel Exp $
 *
 *  $Source: c:/borlandc/poll/rcs/poll.c $
 *
 *
 */

	    #include "poll.h"

short DebugPoll = FALSE;
FILE *fDebug;
char szRev[] = "$Revision: 1.0 $";


int main(int argc, char *argv[])
     {
     time_t t;
     struct COMMANDVALUES CommandValues;
     int x;
     char *szUucico = "UUCICO.EXE";
     char *array[4];
     char szSiteArg[32], szDebug[8];
     char szBuffer[128];
     int ErrorCode, TriesMade, ArgcSiteStart;
     int NumSiteOnNow;
     time_t SecondsStart;
     for (x=11; szRev[x] != ' '; x++) ;
     szRev[x] = '\0';
     sprintf(szBuffer, "\nPoll - v%s -- Copyright (C) 1991 by Greg Montgomery\n\n",
       (char *) &szRev[11]);
     fprintf(stderr,"%s",szBuffer);
     time(&t);
     fprintf(stderr,"%s\n",ctime(&t));
     ArgcSiteStart=ProcessCmdLine(argc, argv, &CommandValues);
     if (DebugPoll)
	{
	fprintf(stderr,"NumSites is %d\n",CommandValues.NumSites);
	fprintf(fDebug,"NumSites is %d\n",CommandValues.NumSites);
	fflush(fDebug);
	}
       // starting main loop
     for (NumSiteOnNow=0; NumSiteOnNow < CommandValues.NumSites ; NumSiteOnNow++)
	{
	if (NumSiteOnNow > 0) // allows modem to reset between calls
	   sleep(8);
	sprintf(szSiteArg,"-s%s",argv[NumSiteOnNow+ArgcSiteStart]);
	sprintf(szDebug,"-x%d",CommandValues.debug);
	if (DebugPoll)
	   {
	   fprintf(stderr,"szSiteArg is \"%s\"\n",szSiteArg);
	   fprintf(fDebug,"szSiteArg is \"%s\"\n",szSiteArg);
	   if (CommandValues.debug != NO_XSWITCH)
	      {
	      fprintf(stderr,"szDebug is \"%s\"\n",szDebug);
	      fprintf(fDebug,"szDebug is \"%s\"\n",szDebug);
	      }
	   }
	if (CommandValues.debug == NO_XSWITCH)
	   {
	   array[0] = szUucico;
	   array[1] = szSiteArg;
	   array[2] = (char *) NULL;
	   array[3] = (char *) NULL;
	   }
	else
	   {
	   array[0] = szUucico;
	   array[1] = szDebug;
	   array[2] = szSiteArg;
	   array[3] = (char *) NULL;
	   }
	if (DebugPoll)
	   {
	   fprintf(stderr,"Array is the following:\n");
	   fprintf(stderr,"%s\n%s\n%s\n%s\n",array[0],array[1], array[2], array[3]);
	   fprintf(fDebug,"Array is the following:\n");
	   fprintf(fDebug,"%s\n%s\n%s\n%s\n",array[0],array[1], array[2], array[3]);
	   fflush(fDebug);
	   }

	// starting secondary loop
	for (TriesMade=1,ErrorCode=1; ErrorCode ; TriesMade++)
	   {
	   ErrorCode=spawnvp(P_WAIT,szUucico,array);
	   if (DebugPoll)
	      {
	      fprintf(stderr,"\nErrorCode is %d\n",ErrorCode);
	      fprintf(fDebug,"\nErrorCode is %d\n",ErrorCode);
	      }
	   if (ErrorCode == -1) // error in spawning
	      {
	      perror("Error from spawnlp");
	      fprintf(stderr,"spawnlp unsuccessful. Errno is %d\n",errno);
	      if (DebugPoll)
		 fclose(fDebug);
	      exit(1);
	      }
	   if (ErrorCode != 0) // if not successful
	      {
	      if (TriesMade >= CommandValues.tries)
		 {
		 printf("\nUnable to contact %s in %d tries\n",argv[NumSiteOnNow+ArgcSiteStart], TriesMade);
		 ErrorCode = 0; // to take us out of the secondary loop
		 break;
		 }
	      SecondsStart=time(NULL) + CommandValues.SecondsToWait;
	      if (DebugPoll)
		 {
		 fprintf(stderr,"\nStarting wait time. Will wait %ld seconds.\n"
					,CommandValues.SecondsToWait);
		 fprintf(fDebug,"\nStarting wait time. Will wait %ld seconds.\n"
					,CommandValues.SecondsToWait);
		 }
	      while(time(NULL) < SecondsStart )
		 if ( kbhit() )
		    if (getch() == 3) // ctrl-c
		       {
		       if (DebugPoll)
			  fclose(fDebug);
		       exit(1);
		       }
	      }
	   if (ErrorCode == 0)
	      printf("\n%s poll successful after %d tries.\n", argv[NumSiteOnNow+ArgcSiteStart],TriesMade);
	   }  // secondary loop
	}     // primary loop
     if (DebugPoll)
	fclose(fDebug);
     exit(0);
     return 0; // to keep the compiler from complaining
     }

