/*===========================================================================
SOLAR slrreply :: Module ..\slrreply\mail.c
Original author : Kevin Houle <kjhoule@iowegia.dsm.ia.us>

This source code has been placed into the public domain.
===========================================================================*/

/* Header files */
#include <stdio.h>
#include <process.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>
#include "mail.h"

/*
 * Function: call_mail()
 * Purpose : Build final mail message and pass to mail program.
 * Return  : 0 on success, non-zero on error and set _slrerr.
*/

int feed_mail()
{
  FILE  *mail_file  = NULL;
  FILE  *final_file = NULL;
  char  destination[128];
  char  execbuf[BUFSIZE];
  char  date_time[35];
  char  command[512];
  char  to[256];
  char  cc[256];
  static char *p = NULL;

  /* Set To: and Cc: headers to NONE */

  strcpy(to,"NONE");
  strcpy(cc,"NONE");

  /* Open the temporary mail file for read */

  if ((mail_file = fopen(REPLY_TMP,"rb")) == NULL)
  {
    sprintf(_slrerr,"feed_mail(): error opening %s.",REPLY_TMP);
    goto ErrorExit;
  }

  /* Get To: and Cc: headers from temporary mail file */

  while (fgets(execbuf,BUFSIZE,mail_file) != NULL)
  {
    if (strlen(execbuf) < 3) break;
    if (strnicmp(execbuf,"To:",3) == 0)
    {
      strcpy(to,execbuf);
    }
    if (strnicmp(execbuf,"Cc:",3) == 0)
    {
      strcpy(cc,execbuf);
    }
  }
  fclose(mail_file);

  /* Make sure there was a To: header */

  if (strcmp(to,"NONE") == 0)
  {
    strcpy(_slrerr,"no destination for mail");
    goto ErrorExit;
  }

  /* Parse multiple addresses out of To: header
     and build/send message to each */

  p = strtok(to,",");
  while (p)
  {
    /* Get the destination for this copy of mail message */

    strcpy(destination,extract_destination(p));
    RPrintf("Sending to: %s\n",destination);

    /* Re-open temporary mail file for read */

    if ((mail_file = fopen(REPLY_TMP,"rb")) == NULL)
    {
      sprintf(_slrerr,"feed_mail(): error opening %s",REPLY_TMP);
      goto ErrorExit;
    }

    /* Open final mail file for write */

    if ((final_file = fopen(REPLY_FINAL,"wb")) == NULL)
    {
      sprintf(_slrerr,"feed_mail(): error opening %s",REPLY_FINAL);
      goto ErrorExit;
    }

    /* Get time stamp in RFC 822 format */

    if (strcpy(date_time,rfctime()) == NULL)
    {
      strcpy(_slrerr,"feed_mail(): error creating rfctime.");
      goto ErrorExit;
    }

    /* Write the From_ and leading Received: headers to
       final mail message */

    fprintf(final_file,"From %s %s\n",username,date_time);

    /* Copy the temporary mail file into
       final mail file */

    while (fgets(execbuf,BUFSIZE,mail_file) != NULL)
    {
      fprintf(final_file,"%s",execbuf);
    }
    fclose(mail_file);
    fclose(final_file);

    /* Build mail program command and execute. Cannot
       use a spawn because of the < redirection */

    strcpy(command,mail_program);
    strcat(command," ");
    strcat(command,destination);
    strcat(command," < ");
    strcat(command,REPLY_FINAL);

    if (verbose == YES)
      RPrintf("Calling: %s\n",command);
    system(command);

    /* Get the next destination from To: header */

    p = strtok(NULL,",");
  }

  /* Perform the same processing for the Cc:
     header, if it exists */

  if (strcmp(cc,"NONE") != 0)
  {
    p = strtok(cc,",");
    while (p)
    {
      strcpy(destination,extract_destination(p));
      RPrintf("Sending Cc to: %s\n",destination);

      if ((mail_file = fopen(REPLY_TMP,"rb")) == NULL)
      {
        sprintf(_slrerr,"feed_mail(): error opening %s",REPLY_TMP);
        goto ErrorExit;
      }
      if ((final_file = fopen(REPLY_FINAL,"wb")) == NULL)
      {
        sprintf(_slrerr,"feed_mail(): error opening %s",REPLY_FINAL);
        goto ErrorExit;
      }
      if (strcpy(date_time,rfctime()) == NULL)
      {
        strcpy(_slrerr,"feed_mail(): error creating rfctime.");
        goto ErrorExit;
      }
      fprintf(final_file,"From %s %s\n",username,date_time);

      while (fgets(execbuf,BUFSIZE,mail_file) != NULL)
      {
        fprintf(final_file,"%s",execbuf);
      }
      fclose(mail_file);
      fclose(final_file);

      strcpy(command,mail_program);
      strcat(command," ");
      strcat(command,destination);
      strcat(command," < ");
      strcat(command,REPLY_FINAL);

      if (verbose == YES)
        RPrintf("Calling: %s\n",command);
      system(command);

      p = strtok(NULL,",");
    }
  }

GoodExit:
  return 0;
ErrorExit:
  if (mail_file) fclose(mail_file);
  if (final_file) fclose(final_file);
  return -1;
}

/*
 * Function: extract_destination()
 * Purpose : Pull single address out of To: header. The address can
 *           be free-standing, or enclosed in < >'s, according to
 *           RFC 822.
 * Return  : Single destination address.
*/

char *extract_destination(char *address)
{
  int  idx  = 0;
  int  idx2 = 0;
  static char final_add[128];

  if ((strnicmp(address,"To:",3) == 0) || (strnicmp(address,"Cc:",3) == 0))
  {
    while (address[idx++] != ':');
    while (address[idx] == ' ') idx++;
  }
  if (strstr(address,"<") != NULL)
  {
    while (address[idx++] != '<');
  }
  while (address[idx] == ' ') idx++;
  while ((address[idx] != '\0') && \
         (address[idx] != '\n') && \
         (address[idx] != '>')  && \
         (address[idx] != ' '))
  {
    final_add[idx2++] = address[idx++];
  }
  final_add[idx2] = '\0';
  return final_add;
}
