#!perl.exe
# PMAIL.PL Perl-based Waffle-Mail Reader
#
# Budi Rahardjo <budi@bison.mb.ca>
# This script is declared as public domain
#
# Modify the following parameters
# Read Parameters
$HELPFILE='pmail.hlp';        # Help file
$MODIFYKBD = 1;               # Let me modify your keypad
$PAGER='list';                # program to display the mail
                              # you could use your editor
$USER='budi';                 # Your userid, which is also the filename
# Send Parameters 
$EDITOR='vde';                # Editor
$EMAILADDR='budi@bison.mb.ca';# Your E-mail Address
$NODENAME='bison';            # Your Node name (minus .UUCP)
$SENDMAIL = 'rmail -ubudi';   # Mail Transport Agent
$TMPMAIL='_temp';             # Temporary filename to compose mail


# START PROGRAM - YOU DON'T HAVE TO TOUCH ANYTHING BELOW THIS
# UNLESS YOU KNOW WHAT YOU'RE DOING
$SIG{'INT'} = 'Quit'; # ctrl-c handler
$|=1; $selmail=1; $mindisplay=1;
&clearscreen; &DisplayHeader;
# set keyboard
&ModifyKbd;

$nmails=&CountMail; 
if ($nmails > 0) { &CollectHeader; }
&clearscreen; &DisplayHeader; &DisplayMenu;
while (($cmd ne '4209')&&($cmd ne 'q')) {
   if ($nmails > 0) { &Display($mindisplay); }
   &GetCommand;
   }
&Quit;

# END OF MAIN LOOP

sub Quit { # reset the keyboard back to normal
   print "Exiting... cleaning up ...\n";
   &RestoreKbd;
   exit(0);
   }

sub GetCommand {
   print "\033[0;37;40m";  # normal text
   print "\033[20;0H";     # goto line 20
   print "    Command: "; &cleareol;
   $cmd = <STDIN>; chop $cmd;
   if ($cmd eq 'g') {                                        # g
      print "\033[21;0H";  # goto line 21
      print '  Goto mail: '; $selmail=<STDIN>; chop $selmail;
      print "\033[21;0H";  # goto line 21
      &cleareol;
      if ($selmail < 1) { $selmail=1;}
      if ($selmail > $nmails) {$selmail = $nmails; }
      $mindisplay=$selmail; return;}
   if ($cmd eq 'h') {
      &RestoreKbd;
      system("$PAGER $HELPFILE");                            # h
      &ModifyKbd;
      &clearscreen; &DisplayHeader; &DisplayMenu;
      return; }
   if ($cmd eq 'k') {$selmail--;                             # k up
      if ($selmail<1) { $selmail=1;}
      if ($selmail < $mindisplay) { 
         $mindisplay = $mindisplay -10;
         if ($mindisplay < 1) {$mindisplay=1;}
         }
      return;} 
   if ($cmd eq 'j') {$selmail++ ;                            # j down
      if ($selmail > $nmails) { $selmail = $nmails; }
      if ($selmail >= ($mindisplay+10)) {$mindisplay=$selmail;} 
      return;}
   if ($cmd eq '') {
      &RestoreKbd;
      system("$PAGER $USER.$selmail");                       # return
      &ModifyKbd;
      &clearscreen; &DisplayHeader; &DisplayMenu;
      return; }
   if ($cmd eq 'm') { 
      &RestoreKbd;
      &CreateMail;                                           # m
      &ModifyKbd;
      &clearscreen; &DisplayHeader; &DisplayMenu;
      return; }  
   }

sub clearscreen {
   print "\033[0;37;40m";  # normal text
   print "\033[2J";        # cls
   }

sub cleareol { print "\033[K"; }

sub Display {
   local($min) = @_;
   local($i);
   print "\033[4;0H";      # Goto line 2 col 0
   for ($i=$min ; $i < $min+10 ; $i++) {
      print "\033[0;37;40m";  # normal text
      &cleareol;
      if ($i > $nmails) { print "\n"; next; }
      if ($i == $selmail) { 
         print "\033[1;37;44m"; # white on blue
         print '->';} 
      else {
         print'  '; }
      printf("%3d. ",$i);
      print substr($from[$i],0,20) . '    ';
      print substr($subject[$i],0,40);
      print "\n";
      }
   }

sub CollectHeader {
   local($i);
   local($fname);
   $/="\n\n"; 
   print "\033[1;33;40m"; &cleareol;
   print "Found $nmails mails   \n";
   for ($i=1 ; $i <= $nmails ; $i++) {
      $fname = $USER . '.' . $i;
      open(MFILE,$fname) || die "Can't open $fname\n";
      print "Reading: $i...   \r";
      $_ = <MFILE>;
      $from[$i] = $_; 
      $from[$i]=~s#^((.*\n)*)From:\s(.*\n)((.*\n)*)#\3#; 
      chop $from[$i];
      $subject[$i]=$_;
      $subject[$i]=~s#^((.*\n)*)Subject:\s(.*\n)((.*\n)*)#\3#;
      chop $subject[$i];
      close(MFILE);
      }
   $/="\n";
   }

sub CountMail {
   local(@allfiles);
   local($i);
   local($pat);
   opendir(THISDIR,".");
   $pat = $USER . '.[0-9].*' ;
   @allfiles = grep(/$pat/,readdir(THISDIR));
   closedir(THISDIR);
   return($#allfiles+1);
   }

sub CenterText {
   local($text)=@_;
   local($i);
   for ($i=1; $i < (79-length($text)) / 2; $i++) { print ' '; }
   print $text . "\n";
   }

sub CreateHeader {
   open(MAIL,">$TMPMAIL") || die "Can't open temporary file $TMPMAIL\n";
   print MAIL 'From '.$NODENAME.'!',$USER."\n";
   print MAIL 'From: '.$EMAILADDR."\n";
   print MAIL 'To: '.$TO."\n";
   print MAIL 'Subject: '.$SUBJECT."\n";
   print MAIL 'X-Mailer: Perl Mailer 0.1'."\n";
   print MAIL "\n";
   print MAIL "Start typing here ...";
   close(MAIL);
   }

sub CreateMail {
   print "Mail To: ";
   $TO=<STDIN>; chop $TO;
   if ($TO eq '') {print "Aborted!"; return; }
   print 'Subject: ';
   $SUBJECT=<STDIN>; chop $SUBJECT;
   if ($SUBJECT eq '') {print "Aborted!"; return; }
   &CreateHeader;
   system("$EDITOR $TMPMAIL");
   print "Send mail ? [y] ";
   $x = <STDIN>; chop $x;
   if (($x eq '')|| ($x eq 'y')) {
      print "Delivering mail...";
      system("$SENDMAIL $TO < $TMPMAIL");
      }
   else { print "Aborted..."; }
   }

sub DisplayHeader {
   print "\033[1;37;41m";  # White on Red
   print "               <<< Perl Mailer v 0.2 - Total mails: $nmails >>>                 \n";
   print "\033[0;37;40m";  # normal text
   }

sub DisplayMenu {
   print "\033[15;0H";     # goto line 15
   print "\033[1;33;40m";
   # &CenterText("F1=help  Alt-F4=Exit");
   &CenterText("------------------------------------------");
   &CenterText("j or keypad + = down    k or keypad - = up"); 
   &CenterText("g)oto  h)elp  m)ail  q)uit");
   &CenterText("use 'return' to view mail");
   &CenterText("------------------------------------------");
   print "\033[0;37;40m";
   }

sub ModifyKbd {
   if ($MODIFYKBD == 1) {
   print "\033[43;106;13p";    # keypad + becomes j\n
   print "\033[45;107;13p";    # keypad -  ->  k\n
   }
   }
sub RestoreKbd {
   if ($MODIFYKBD == 1) {
   print "\033[43;43p";  # set keypad + back to normal
   print "\033[45;45p";  # keypad -
   }
   }

