#--------------------------------------------------------------------------#
#                                                                          #
#       FX - TW-523 Special Effects Interpreter - V1.00                    #
#       Copyright 1992-93 by Bruce Christensen. All Rights Reserved.       #
#                                                                          #
#--------------------------------------------------------------------------#

# 
# Define the printer port to use (LPT1, LPT2, LPT3).
#
# LPT1
#
#
# This section defines the module address for each color.
# NOTE:
#   To get a simultaneous DIM/BRIGHT command, each module 
#   MUST have a unique HOUSE code.
#
DEFINE RED   L1
DEFINE GREEN M1
DEFINE BLUE  N1
DEFINE WHITE O1
DEFINE PC    C3
DEFINE PORCH A9

#
# Define the time we should shut down.
# This is placed in here because it's unlikely the CP-290 will be able
# to send a signal through to the Appliance module controlling the XMAS
# computer (which is generating lots of X10 signals). This allows a 
# more controlled shutdown as well. When the time is reached, the 
# interpreter will immediately begin executing the EXIT instructions,
# which include turning each light off as well as turning the computer off
# too.
#
TIME 11:30 PM

#
# This section turns ON all modules. It is never executed again
#
:START
PORCH DIM 5
RED ON 
BLUE ON 
GREEN ON 
WHITE ON 
DELAY 5
WHITE DIM 10 + RED DIM 20
# Blue/Green
DELAY 5

#
# This is the start of the loop.
# 
:START_LOOP
RED BRIGHT 5 + BLUE DIM 20
# Red/Green
DELAY 5
BLUE BRIGHT 5 + GREEN DIM 20 
# Red/Blue
DELAY 5
WHITE BRIGHT 5 + RED DIM 5 + BLUE DIM 20
# White
DELAY 5
BLUE BRIGHT 5 + WHITE DIM 5 + GREEN BRIGHT 20 
# Blue/Green
DELAY 5
# 
# Repeat this loop twice...
#
GOTO START_LOOP 2

#
# ...Now setup for the next loop.
# Start out with the WHITE, RED, and GREEN strands dimly lit.
#
WHITE BRIGHT 5
RED BRIGHT 5
GREEN DIM 15 
# Blue fully bright (others @ 25%)

#
# This is the next loop...
#
:LOOP2

BLUE DIM 1 + RED BRIGHT 15
DELAY 2
RED DIM 1 + GREEN BRIGHT 15
DELAY 2
GREEN DIM 1 + WHITE BRIGHT 15
DELAY 2
WHITE DIM 1 + BLUE BRIGHT 15
DELAY 2
#
# Execute this loop twice...  
#
GOTO LOOP2 2

GREEN DIM 1 + WHITE DIM 1 + RED BRIGHT 20
# Blue/Red fully lit (others dim)
DELAY 5
GREEN BRIGHT 5 + BLUE DIM 20
# Red/Green
DELAY 5
BLUE BRIGHT 5 + RED DIM 20
#Blue/Green
DELAY 5
GREEN DIM 20

#
# This is the next loop...
#
:LOOP3

WHITE BRIGHT 5 + BLUE DIM 20
RED BRIGHT 5 + WHITE DIM 20
GREEN BRIGHT 5 + RED DIM 20
BLUE BRIGHT 5 + GREEN DIM 20
#
# Execute this loop three times...  
#
GOTO LOOP3 3

GREEN BRIGHT 20
# Blue/Green Bright
DELAY 3

#
# Execute this loop forever...  
#
GOTO START_LOOP


#
# Special shutdown sequence that occurs whenever the preset time
# is reached, or the user presses the <ESC> key. This will ensure
# that ALL Christmas lights are shut off, the porch light is restored,
# and the PC is turned off. 
#
:EXIT
RED OFF 
BLUE OFF 
GREEN OFF 
WHITE OFF
PORCH BRIGHT 20
PC OFF
