/*--------------------------------------------------------------------------*/
/* Header file containing all definitions specific to Zmodem transfers.     */
/*--------------------------------------------------------------------------*/

#define ZPAD            '*'
#define ZDLE            030
#define ZDLEE           (ZDLE^0100)
#define ZBIN            'A'
#define ZHEX            'B'
#define ZBIN32          'C'
/*
Here are the two new indicators. These are used in GetHeader (ZMISC.C) to
determine the type of header.
*/
#define ZBINC           'G'            /* Compression & CRC-16              */
#define ZBINC32         'H'            /* Compression & CRC-32              */

/*
 Frame types
*/
#define ZRQINIT    0
#define ZRINIT     1
#define ZSINIT     2
#define ZACK       3
#define ZFILE      4
#define ZSKIP      5
#define ZNAK       6
#define ZABORT     7
#define ZFIN       8
#define ZRPOS      9
#define ZDATA      10
#define ZEOF       11
#define ZFERR      12
#define ZCRC       13
#define ZCHALLENGE 14
#define ZCOMPL     15
#define ZCAN       16
#define ZFREECNT   17
#define ZCOMMAND   18
#define ZSTDERR    19

/*
 ZDLE sequences
*/
#define ZCRCE           'h'            /* CRC next/frame ends/hdr follows   */
#define ZCRCG           'i'            /* CRC next/frame continues nonstop  */
#define ZCRCQ           'j'            /* CRC next/frame continues/want ZACK*/
#define ZCRCW           'k'            /* CRC next/ZACK expected/end of frame*/
#define ZRUB0           'l'            /* Translate to rubout 0177          */
#define ZRUB1           'm'            /* Translate to rubout 0377          */

/*
These are the brand new frame ends which will be sent by the sender to tell
the receiver that the packet just sent is a compressed packet. The compressed
packet can be any valid packet from full streaming to wait.
*/
#define ZCRCE_C         'p'            /* as ZCRCE plus using compression.  */
#define ZCRCG_C         'q'            /* as ZCRCG plus using compression.  */
#define ZCRCQ_C         'r'            /* as ZCRCQ plus using compression.  */
#define ZCRCW_C         's'            /* as ZCRCW plus using compression.  */

/*--------------------------------------------------------------------------*/
/* Z_GetZDL return values (internal)                                        */
/* -1 is general error, -2 is timeout                                       */
/*--------------------------------------------------------------------------*/
#define GOTOR           256
#define GOTCRCE         (ZCRCE|GOTOR)  /* ZDLE-ZCRCE received  (Dec. 360)   */
#define GOTCRCG         (ZCRCG|GOTOR)  /* ZDLE-ZCRCG received  (Dec. 361)   */
#define GOTCRCQ         (ZCRCQ|GOTOR)  /* ZDLE-ZCRCQ received  (Dec. 362)   */
#define GOTCRCW         (ZCRCW|GOTOR)  /* ZDLE-ZCRCW received  (Dec. 363)   */

/*
These are the brand new frame ends which will be sent by the sender to tell
the receiver that the packet just sent is a compressed packet. The compressed
packet can be any valid packet from full streaming to wait.
*/
#define GOTCRCE_C     (ZCRCE_C|GOTOR)  /* As GOTCRCE plus using compression */
#define GOTCRCG_C     (ZCRCG_C|GOTOR)  /* As GOTCRCG plus using compression */
#define GOTCRCQ_C     (ZCRCQ_C|GOTOR)  /* As GOTCRCQ plus using compression */
#define GOTCRCW_C     (ZCRCW_C|GOTOR)  /* As GOTCRCW plus using compression */

/*
 Byte positions within header array
*/
#define ZF0             3              /* First flags char                  */
#define ZF1             2
#define ZF2             1
#define ZF3             0

#define ZP0             0              /* Low order 8 bits of position      */
#define ZP1             1
#define ZP2             2
#define ZP3             3              /* High order 8 bits of file pos     */


/*
 Bit Masks for ZRINIT flags char ZF0
*/
#define CANFDX          1             /* Can send and receive true FDX     */
#define CANOVIO         2             /* Can receive data during disk I/O  */
#define CANBRK          4             /* Can send a break signal           */
#define CANFC32         32            /* Can use 32 bit Frame Check        */
#define ESCCTL          64       /* Receiver expects ctl chars to be escaped */
#define ESC8            128      /* Receiver expects 8th bit to be escaped   */

/*
 Bit Masks for ZRINIT flags char ZF1

 These masks are essential for Zreceive/Zsend to determine whether we can
 send or receive in fast mode and/or compressed mode.
*/
#define CANFAST          4            /* Transfer without escaping (exc. DLE*/
#define CANBIG           8            /* Can send 4096 byte blocks.         */
#define CANCOMP         16            /* Can transfer using compression.    */


/*
 Bit Masks for ZSINIT flags byte ZF0
*/
#define TESCCTL         64   /* Transmitter expects ctl chars to be escaped */
#define TESC8           128    /* Transmitter expects 8th bit to be escaped */


/*
 Conversion options - generally we want ZCRESUM
*/
#define ZCBIN           1              /* Binary transfer - no conversion   */
#define ZCNL            2              /* Convert NL to local EOLN          */
#define ZCRESUM         3              /* Resume interrupted file transfer  */



#define ZMSKNOLOC       0200           /* Skip file if not present at rx    */

/*
 Management options
 These are ignored by MpModem - rather irrelevant.
*/
#define ZMMASK          31        /* Mask for the choices below             */
#define ZMNEWL          1         /* Transfer if source newer/longer        */
#define ZMCRC           2         /* Transfer if different CRC/length       */
#define ZMAPND          3         /* Append contents to existing file       */
#define ZMCLOB          4         /* Replace existing file                  */
#define ZMNEW           5         /* Transfer if source newer               */
#define ZMDIFF          6         /* Transfer if dates or lengths different */
#define ZMPROT          7         /* Protect destination file               */
#define ZMCHNG          8         /* Change filename if destination exists  */

[...]
/*
 Miscellaneous definitions
*/
#define ZOK             0
#define ZERROR          (-1)
#define ZTIMEOUT        (-2)

[...]
